<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>App Emas | Log in</title>
    <link rel="icon" href="data:image/png;base64,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" type="image/x-icon">

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/internal/plugins/fontawesome-free/css/all.min.css')); ?>">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/internal/plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/internal/dist/css/adminlte.min.css')); ?>">
</head>
<body class="hold-transition login-page">
<div class="login-box">
  <div class="login-logo">
    <!-- <a href="../../index2.html"><b>Admin</b>LTE</a> -->
  </div>
  <!-- /.login-logo -->
  <div class="card">
    <div class="card-body login-card-body">
      <!-- <p class="login-box-msg">Login</p> -->
       <center><h3 style="text-align: center;">Login</h3></center>
        <div class="input-group mb-3">
          <input type="text" id="username" class="form-control" placeholder="Email">
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-envelope"></span>
            </div>
          </div>
        </div>
        <div class="input-group mb-3">
          <input type="password" id="password" class="form-control" placeholder="Password">
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-lock"></span>
            </div>
          </div>
        </div>
        <div class="row">
          <!-- /.col -->
          <div class="col-12">
            <button type="submit" class="btn btn-primary btn-block" id="btn-login">Sign In</button>
          </div>
          <!-- /.col -->
        </div>
    </div>
    <!-- /.login-card-body -->
  </div>
</div>
<!-- /.login-box -->

<!-- jQuery -->
<script src="<?php echo e(asset('assets/internal/plugins/jquery/jquery.min.js')); ?>"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo e(asset('assets/internal/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
<!-- AdminLTE App -->
<script src="<?php echo e(asset('assets/internal/dist/js/adminlte.min.js')); ?>"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
</body>
</html>

<script>
    // Handle the click event for the login button
    $('#btn-login').click(function(){
        loginUser();
    });

    // Handle "Enter" key press event
    $('#username, #password').keypress(function(e){
        if(e.which == 13) {  // Enter key is pressed
            loginUser();
        }
    });

    // Function to perform login
    function loginUser() {
        $.ajax({
            url : `<?php echo e(route('on.login')); ?>`,
            data : {
                username : $('#username').val(),
                password : $('#password').val(),
                _token : '<?php echo e(csrf_token()); ?>'
            },
            type : 'POST',
            success:function(response){
                if(response.status){
                    window.location.href = '/harga-emas';
                }else{
                    swal("Error", response.message, "error");
                }
            }
        });
    }
</script>
<?php /**PATH /home/xcrt55/public_html/resources/views/internal/login.blade.php ENDPATH**/ ?>