<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta content="width=device-width, initial-scale=1.0" name="viewport" />
        <title>Web Apps - EMAS</title>
        <meta name="description" content="" />
        <meta name="keywords" content="" />

        <!-- Favicons -->
        <link href="<?php echo e(asset('assets/img/favicon.png')); ?>" rel="icon" />
        <link href="<?php echo e(asset('assets/img/apple-touch-icon.png')); ?>" rel="apple-touch-icon" />

        <!-- Fonts -->
        <link href="https://fonts.googleapis.com" rel="preconnect" />
        <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin />
        <link
            href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Ubuntu:ital,wght@0,300;0,400;0,500;0,700;1,300;1,400;1,500;1,700&display=swap"
            rel="stylesheet"
        />

        <!-- Vendor CSS Files -->
        <link href="<?php echo e(asset('assets/vendor/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('assets/vendor/bootstrap-icons/bootstrap-icons.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('assets/vendor/aos/aos.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('assets/vendor/glightbox/css/glightbox.min.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('assets/vendor/swiper/swiper-bundle.min.css')); ?>" rel="stylesheet" />

        <!-- Main CSS File -->
        <link href="<?php echo e(asset('assets/css/main.css')); ?>" rel="stylesheet" />

        <!-- =======================================================
  * Template Name: eNno
  * Template URL: https://bootstrapmade.com/enno-free-simple-bootstrap-template/
  * Updated: Aug 07 2024 with Bootstrap v5.3.3
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
    </head>

    <body class="index-page">
        <header id="header" class="header d-flex align-items-center sticky-top">
            <div class="container-fluid container-xl position-relative d-flex align-items-center">
                <a href="index.html" class="logo d-flex align-items-center me-auto">
                    <h1 class="sitename">Beli Emas Antam</h1>
                </a>

                <nav id="navmenu" class="navmenu">
                    <ul>
                        <li><a href="#hero" class="active">Beranda</a></li>
                        <li><a href="#about">Tentang Kami</a></li>
                        <li><a href="#testimoni">Testimoni </a></li>
                        <li><a href="#footer">Hubungi Kami</a></li>
                    </ul>
                    <i class="mobile-nav-toggle d-xl-none bi bi-list"></i>
                </nav>

                <a class="btn-getstarted" href="<?php echo e(route('home')); ?>">Get Started</a>
            </div>
        </header>

        <main class="main">
            <!-- Hero Section -->
            <section id="hero" class="hero section">
                <div class="container">
                    <div class="row gy-4">
                        <div class="col-lg-6 order-2 order-lg-1 d-flex flex-column justify-content-center" data-aos="fade-up">
                            <h1>Logam Mulia</h1>
                            <p style="text-align: justify;">Logam Mulia ANTAM (produk PT. Antam Tbk) merupakan emas dengan kadar kemurnian tertinggi 99.99% dan telah diakui secara global dengan mendapatkan sertifikasi LBMA (London Bullion Market Association). Edisi terbaru ini telah dilengkapi dengan kemasan certicard guna memudahkan pengecekan keaslian logam mulia Anda.</p>
                        </div>
                        <div class="col-lg-6 order-1 order-lg-2 hero-img" data-aos="zoom-out" data-aos-delay="100">
                            <div class="row">
                                <div class="col-md-8">
                                    <h6 style="font-style: italic;">Harga Logam Mulia Berdasarkan Aneka Tambang</h6>
                                </div>
                                <div class="col-md-4">
                                    <h3 style="margin-bottom: 20px;">  <?php echo e('Rp. ' . number_format($result_pergram[0]->harga, 0, ',', '.')); ?></h3>
                                </div>
                            </div>
                            <table class="table table-bordered" style="margin-left: auto; margin-right: auto;">
                                <tr>
                                    <th style="text-align: center;">No</th>
                                    <th style="text-align: center;">Berat</th>
                                    <th style="text-align: center;">Harga</th>
                                </tr>
                                <tbody>
                                    <?php $__currentLoopData = $result_harga; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td style="text-align: center;"><?php echo e($loop->iteration); ?></td>
                                        <td style="text-align: center;"><?php echo e($v->berat); ?> </td>
                                        <td style="text-align: center;">
                                        <?php echo e('Rp. ' . number_format($v->harga, 0, ',', '.')); ?>

                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </section>
            <!-- /Hero Section -->

            <!-- About Section -->
            <section id="about" class="about section">
                <!-- Section Title -->
                <div class="container section-title" data-aos="fade-up">
                    <span>About Us<br /></span>
                    <h2>Tentang Kami</h2>
                    <p>Necessitatibus eius consequatur ex aliquid fuga eum quidem sint consectetur velit</p>
                </div>
                <!-- End Section Title -->

                <div class="container">
                    <div class="row gy-4">
                        <div class="col-lg-6 position-relative align-self-start" data-aos="fade-up" data-aos-delay="100">
                            <img src="assets/img/about.png" class="img-fluid" alt="" />
                            <a href="https://www.youtube.com/watch?v=Y7f98aduVJ8" class="glightbox pulsating-play-btn"></a>
                        </div>
                        <div class="col-lg-6 content" data-aos="fade-up" data-aos-delay="200">
                            <h3>Voluptatem dignissimos provident quasi corporis voluptates sit assumenda.</h3>
                            <p class="fst-italic">
                                Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
                            </p>
                            <ul>
                                <li><i class="bi bi-check2-all"></i> <span>Ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></li>
                                <li><i class="bi bi-check2-all"></i> <span>Duis aute irure dolor in reprehenderit in voluptate velit.</span></li>
                                <li>
                                    <i class="bi bi-check2-all"></i>
                                    <span>Ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate trideta storacalaperda mastiro dolore eu fugiat nulla pariatur.</span>
                                </li>
                            </ul>
                            <p>
                                Ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident
                            </p>
                        </div>
                    </div>
                </div>
            </section>
            <!-- /About Section -->

            <!-- Testimonials Section -->
            <section id="testimoni" class="testimonials section light-background">
                <!-- Section Title -->
                <div class="container section-title" data-aos="fade-up">
                    <span>Testimoni</span>
                    <h2>Testimoni</h2>
                    <p><?php echo $deskripsi_testimoni; ?></p>
                </div>
                <!-- End Section Title -->

                <div class="container" data-aos="fade-up" data-aos-delay="100">
                    <div class="swiper init-swiper" data-speed="600" data-delay="5000" data-breakpoints='{ "320": { "slidesPerView": 1, "spaceBetween": 40 }, "1200": { "slidesPerView": 3, "spaceBetween": 40 } }'>
                        <script type="application/json" class="swiper-config">
                            {
                                "loop": true,
                                "speed": 500,
                                "autoplay": {
                                    "delay": 4000
                                },
                                "slidesPerView": "auto",
                                "pagination": {
                                    "el": ".swiper-pagination",
                                    "type": "bullets",
                                    "clickable": true
                                },
                                "breakpoints": {
                                    "320": {
                                        "slidesPerView": 1,
                                        "spaceBetween": 40
                                    },
                                    "1200": {
                                        "slidesPerView": 3,
                                        "spaceBetween": 20
                                    }
                                }
                            }
                        </script>
                        <div class="swiper-wrapper">
                        <?php $__currentLoopData = $result_testimoni; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="swiper-slide">
                            <div class="testimonial-item">
                                <p>
                                    <i class="bi bi-quote quote-icon-left"></i>
                                    <span><?php echo $v->testimoni; ?></span>
                                    <i class="bi bi-quote quote-icon-right"></i>
                                </p>
                                <?php if($v->foto == ''): ?>
                                    <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRKaiKiPcLJj7ufrj6M2KaPwyCT4lDSFA5oog&s" class="testimonial-img" alt="">
                                <?php else: ?>
                                    <img src="<?php echo e(asset('assets/img/testimonials/testimonials-2.jpg')); ?>" class="testimonial-img" alt="" />
                                <?php endif; ?>
                                <h3><?php echo e($v->user_testimoni); ?></h3>
                                <h4><?php echo e($v->title_testimoni); ?></h4>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <!-- End testimonial item -->

                    </div>
                    <div class="swiper-pagination"></div>
                </div>
            </section>
            <!-- /Testimonials Section -->

            <!-- Call To Action Section -->
            <section id="call-to-action" class="call-to-action section accent-background">
                <div class="container">
                    <div class="row justify-content-center" data-aos="zoom-in" data-aos-delay="100">
                        <div class="col-xl-10">
                            <div class="text-center">
                                <h3>Call To Action</h3>
                                <p>
                                    Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est
                                    laborum.
                                </p>
                                <a class="cta-btn" href="#">Call To Action</a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- /Call To Action Section -->
        </main>

        <footer id="footer" class="footer">
            <div class="container footer-top">
                <div class="row gy-4">
                    <div class="col-lg-4 col-md-6 footer-about">
                        <a href="index.html" class="d-flex align-items-center">
                            <span class="sitename">eNno</span>
                        </a>
                        <div class="footer-contact pt-3">
                            <p>A108 Adam Street</p>
                            <p>New York, NY 535022</p>
                            <p class="mt-3"><strong>Phone:</strong> <span>+1 5589 55488 55</span></p>
                            <p><strong>Email:</strong> <span>info@example.com</span></p>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-3 footer-links">
                        <h4>Section</h4>
                        <ul>
                            <li><i class="bi bi-chevron-right"></i> <a href="#hero">Beranda</a></li>
                            <li><i class="bi bi-chevron-right"></i> <a href="#about">Tentang Kami</a></li>
                            <li><i class="bi bi-chevron-right"></i> <a href="#testimoni">Testimoni</a></li>
                            <li><i class="bi bi-chevron-right"></i> <a href="#footer">Hubungi Kami</a></li>
                        </ul>
                    </div>

                    <div class="col-lg-4 col-md-12">
                        <h4>Follow Us</h4>
                        <!-- <p>Cras fermentum odio eu feugiat lide par naso tierra videa magna derita valies</p> -->
                        <div class="social-links d-flex">
                            <a href=""><i class="bi bi-twitter-x"></i></a>
                            <a href=""><i class="bi bi-facebook"></i></a>
                            <a href=""><i class="bi bi-instagram"></i></a>
                            <a href=""><i class="bi bi-linkedin"></i></a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container copyright text-center mt-4">
                <?php echo e(str_replace('https://','',url()->current())); ?><br>
                <p>Copyright &copy; <?php echo e(date('Y')); ?> <strong>Beli Emas Antam</strong>. All Rights Reserved</p>
            </div>
        </footer>

        <!-- Scroll Top -->
        <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

        <!-- Preloader -->
        <div id="preloader"></div>

        <!-- Vendor JS Files -->
        <script src="<?php echo e(asset('assets/vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/vendor/php-email-form/validate.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/vendor/aos/aos.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/vendor/glightbox/js/glightbox.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/vendor/purecounter/purecounter_vanilla.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/vendor/imagesloaded/imagesloaded.pkgd.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/vendor/isotope-layout/isotope.pkgd.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/vendor/swiper/swiper-bundle.min.js')); ?>"></script>

        <!-- Main JS File -->
        <script src="<?php echo e(asset('assets/js/main.js')); ?>"></script>
    </body>
</html>
<?php /**PATH C:\Users\nvdni\Documents\Web Emas - Pak Ardhi\app_emas\resources\views/beranda/index.blade.php ENDPATH**/ ?>