<?php

use App\Http\Controllers\AboutController;
use App\Http\Controllers\BerandaController;
use App\Http\Controllers\CallToActionController;
use App\Http\Controllers\InBerandaControlller;
use App\Http\Controllers\InFooterController;
use App\Http\Controllers\InHargaEmasController;
use App\Http\Controllers\InHargaTrenEmasController;
use App\Http\Controllers\InTestimonialController;
use App\Http\Controllers\InUserController;
use App\Http\Controllers\InLoginController;
use App\Http\Controllers\SEOController;
use Illuminate\Support\Facades\Route;

Route::get('/',[BerandaController::class,'index'])->name('home');
Route::get('/adm-login',[InLoginController::class,'index'])->name('adm.login');
Route::post('/login.adm-login',[InLoginController::class,'prosesLogin'])->name('on.login');
Route::get('/login.adm-logout',[InLoginController::class,'prosesLogout'])->name('on.logout');

Route::middleware(['admin'])->group(function () {
/** internal */
    Route::get('/adm-beranda',[InBerandaControlller::class,'index']);
    
    /** testimoni */
    Route::get('/adm-testimoni',[InTestimonialController::class,'index'])->name('adm.testimoni');
    Route::post('/adm-testimoni-store',[InTestimonialController::class,'store'])->name('adm.testimoni.store');
    Route::post('/testimoni/delete',[InTestimonialController::class,'deleteTestimoni'])->name('adm.testimoni.delete');
    Route::post('/testimoni/update/deskripsi',[InTestimonialController::class,'updateDeskripsi'])->name('adm.testimoni.update');
    Route::post('/testimoni/update/testimoni',[InTestimonialController::class,'updateTestimoni'])->name('adm.testimoni.update.testimoni');
    Route::post('/testimoni/edit',[InTestimonialController::class,'edit'])->name('adm.edit.testimoni');

    /** harga emas master data */
    Route::get('/harga-emas',[InHargaEmasController::class,'index'])->name('adm.harga.emas');
    Route::post('/upload-harga-emas',[InHargaEmasController::class,'uploadHargaEmas'])->name('upload.file.emas');
    Route::post('/hapus-harga-emas',[InHargaEmasController::class,'hapusHargaEmas'])->name('delete.row.emas');
    Route::post('/hapus-harga-tren-emas',[InHargaTrenEmasController::class,'hapusHargaEmas'])->name('delete.row.tren.emas');

    /** akses usser */
    Route::get('/adm-user-akses',[InUserController::class,'index'])->name('adm.users');
    Route::post('/adm-user-akses/tambah',[InUserController::class,'tambahData'])->name('adm.users.store');
    Route::post('/adm-user-delete',[InUserController::class,'deleteUser'])->name('adm.users.delete');
    Route::post('/adm-user-edit',[InUserController::class,'editRows'])->name('adm.users.edit');
    Route::post('/adm-user-update',[InUserController::class,'updateRows'])->name('adm.users.update');
    Route::post('/adm-update-password',[InUserController::class,'updatePassword'])->name('adm.users.update.password');

    /** SEO Controller */
    Route::get('/seo-meta',[SEOController::class,'index'])->name('adm.seo');
    Route::post('/update-seo-meta',[SEOController::class,'updateSEO'])->name('adm.seo.update');

    /** call to action */
    Route::get('/call-action',[CallToActionController::class,'index'])->name('adm.call-action');
    Route::post('/update-call-action',[CallToActionController::class,'updateCallToAction'])->name('adm.calltoaction.update');

    /** about */
    Route::get('/about',[AboutController::class,'index'])->name('adm.about');
    Route::post('/update-about',[AboutController::class,'updateAbout'])->name('adm.about.update');

    Route::get('/get-harga-emas',[InHargaEmasController::class,'grabHargaEmas'])->name('adm.harga.emas.tarik');

    Route::get('/harga-tren-emas',[InHargaTrenEmasController::class,'index'])->name('adm.tren.harga.emas');
    Route::post('/update-harga-tren-emas',[InHargaTrenEmasController::class,'updateHargaTrenEmas'])->name('input.harga.emas');
    /** footer */
    Route::get('/footer',[InFooterController::class,'index'])->name('adm.footer');
});

 Route::get('/get-tren-emas',[InHargaEmasController::class,'trenEmas'])->name('adm.tren.emas');
/** internal testimoni */
