@extends('internal.layouts.index')
@section('content')

<!-- /.row -->
<!-- Main row -->
<div class="row">
    <!-- Left col -->
    <section class="col-lg-12 connectedSortable">
    <!-- Custom tabs (Charts with tabs)-->
    <div class="card">
        <div class="card-header">
        <h3 class="card-title">
            <h2>User Akses<h2>
        </h3>
        <div class="card-tools">
            <ul class="nav nav-pills ml-auto">
        </div>
        </div><!-- /.card-header -->
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <button class="btm btn-primary btn-sm" data-toggle="modal" data-target="#myModal" style="margin: 10px;"><i class="fas fa-plus-circle"></i> Tambah User </button>
                </div>
            </div>
            <div class="table table-responsive">
                <input type="hidden" id="id_user_update">
                <table id="table" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th style="text-align: center;">No</th>
                            <th style="text-align: center;">Username</th>
                            <th style="text-align: center;">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($result_data as $k => $v)
                            <tr>
                                <td style="text-align: center;">{{ $loop->iteration }}</td>
                                <td style="text-align: center;">{{ $v->username }}</td>
                                <td style="text-align: center;">
                                    <button class="btn btn-warning btn-sm" data-toggle="modal" data-id="{{ $v->id_m_users }}" data-target="#gantiPassword" onclick="return getGantiPassword(`{{ $v->id_m_users }}`)">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-danger btn-sm" onclick="return DeleteData(`{{ $v->id_m_users }}`)">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div><!-- /.card-body -->
    </div>
    </section>
</div>

<div id="gantiPassword" class="modal fade" role="dialog">
  <div class="modal-dialog modal-lg">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Ganti Password</h4>
      </div>
      <div class="modal-body">
        <div class="row" style="margin: 10px;">
            <div class="col-md-3">
                <label for="">Password Baru</label>
            </div>
            <div class="col-md-9">
                <input type="password" class="form-control" id="show-password-baru">
                <input type="checkbox" id="password-baru"> Lihat Password
            </div>
        </div>
        <div class="row" style="margin: 10px;">
            <div class="col-md-3">
                <label for="">Ketik Password Baru</label>
            </div>
            <div class="col-md-9">
                <input type="password" class="form-control" id="show-password-baru-ulang">
                <input type="checkbox" id="password-baru-ulang"> Lihat Password
            </div>
        </div>

        <div class="row" style="margin: 10px;">
            <h6>Ketentuan Password : </h6>
            <ul>
                <li> Panjang string minimal 8 karakter. </li>
                <li> Ada satu huruf kapital. </li>
                <li> Ada setidaknya satu angka. </li>
            </ul>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-primary" id="btn-ganti-password">Submit</button>
        <button class="btn btn-danger" data-dismiss="modal">Tutup</button>
      </div>
    </div>

  </div>
</div>

<!-- Modal -->
<div id="myModal" class="modal fade" role="dialog">
  <div class="modal-dialog modal-lg">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Tambah User Akses</h4>
      </div>
      <div class="modal-body">
        <div class="row" style="margin: 10px;">
            <div class="col-md-3">
                <label>Username</label>
            </div>
            <div class="col-md-7">
                <input type="text" id="username-tambah" class="form-control" id="username" name="username">
            </div>
        </div>
        <div class="row"  style="margin: 10px;">
            <div class="col-md-3">
                <label>Password</label>
            </div>
            <div class="col-md-7">
                <input type="password" id="password-tambah" class="form-control"> 
                <input type="checkbox" value="lihat password" id="showPassword___"> Lihat Password
            </div>
        </div>

        <div class="row" style="margin: 10px;">
            <h6>Ketentuan Password : </h6>
            <ul>
                <li> Panjang string minimal 8 karakter. </li>
                <li> Ada satu huruf kapital. </li>
                <li> Ada setidaknya satu angka. </li>
            </ul>
        </div>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary" id="tambah-user">Tambah</button>
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>
    </div>

  </div>
</div>

<!-- /.row (main row) -->
@endsection

@section('internal.layouts.script')
<script>
    $('#btn-update-password').click(function(){
        let id = $(this).data('id');
    });

    $('#password-baru').click(function(){
        var passwordField = $('#show-password-baru');

        // Mengecek tipe input, jika password, ganti menjadi text untuk menampilkan password
        if (passwordField.attr('type') === 'password') {
            passwordField.attr('type', 'text');
        } else {
            // Jika sudah dalam bentuk text, ubah kembali ke password
            passwordField.attr('type', 'password');
        }
    });

    $('#password-baru-ulang').click(function(){
        var passwordField = $('#show-password-baru-ulang');

        // Mengecek tipe input, jika password, ganti menjadi text untuk menampilkan password
        if (passwordField.attr('type') === 'password') {
            passwordField.attr('type', 'text');
        } else {
            // Jika sudah dalam bentuk text, ubah kembali ke password
            passwordField.attr('type', 'password');
        }
    });

    $('#showPassword___').click(function(){
        var passwordField = $('#password-tambah');

        // Mengecek tipe input, jika password, ganti menjadi text untuk menampilkan password
        if (passwordField.attr('type') === 'password') {
            passwordField.attr('type', 'text');
        } else {
            // Jika sudah dalam bentuk text, ubah kembali ke password
            passwordField.attr('type', 'password');
        }
    });

    $('#tambah-user').click(function(){
        let $post = {};
            $post['username'] = $('#username-tambah').val(); 
            $post['password'] = $('#password-tambah').val(); 
            $post['_token'] = '{{ csrf_token() }}';
            $.post("{{ route('adm.users.store') }}", $post, function(data){
                if(data.status){
                    $('#username-tambah').val('');
                    $('#password-tambah').val('');
                    $('#modal-tambah').modal('hide');

                swal(data.message, {
                        icon: "success",
                    });

                    setTimeout(function(){ 
                        location.reload();
                    }, 500);
                }else{
                    swal(data.message, {
                        icon: "error",
                    });
                }

                // location.reload();
                
            });
    });
    
    function DeleteData($id)
    {
        swal({
            title: "",
            text: "Apakah ingin menghapus data ini ?",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url: "{{ route('adm.users.delete') }}",
                    type: "POST",
                    data :{
                        id: $id,
                        _token: "{{ csrf_token() }}"  
                    },
                    success: function (response) {
                        if (response.status){
                            swal("Data berhasil dihapus!", {
                                icon: "success",
                            });
                            setTimeout(function(){ 
                                location.reload();
                            }, 500);
                        }
                    }
                });
            }
        });
    }

    $('#btn-ganti-password').click(function(){
        $.ajax({
            url: "{{ route('adm.users.update.password') }}",
            type: "POST",
            data: {
                id: $('#id_user_update').val(),
                password: $('#show-password-baru').val(),
                password_baru: $('#show-password-baru-ulang').val(),
                _token: '{{ csrf_token() }}'
            },
            success: function(data){
                if (data.status){
                    swal(data.message, {
                        icon: "success",
                    });
                    setTimeout(function(){ 
                        location.reload();
                    }, 500);
                }else{
                    swal(data.message, {
                        icon: "error",
                    });
                }
            }
        })
    });

    function getGantiPassword($id){
        $('#id_user_update').val($id);
    };
</script>
@endsection