@extends('internal.layouts.index')
@section('content')
<style>
    #summernote {
        height: 300px; /* You can change this to whatever height you prefer */
    }
</style>

<div class="row">
    <!-- Left col -->
    <section class="col-lg-12 connectedSortable">
    <!-- Custom tabs (Charts with tabs)-->
    <div class="card">
        <div class="card-header">
        <h3 class="card-title">
            <h2>Tentang Kami <h2>
        </h3>
        <div class="card-tools">
            <ul class="nav nav-pills ml-auto">
        </div>
        </div><!-- /.card-header -->
        <div class="card-body">
        
        <div class="row">
            <div class="col-md-6">
            <div class="form-group">
                <label for="email">Title</label>
                <input type="text" class="form-control" id="title-about" value="{{ (isset($result->title)) ? $result->title: '' }}">
            </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
            <div class="form-group">
                <label for="email">Deskripsi</label>
                <textarea name="default" id="deskripsi-about"> {{ (isset($result->deskripsi)) ? $result->deskripsi : '' }}</textarea>
            </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
            <div class="form-group">
                <label for="email">Deskripsi Content </label>
                <textarea name="default" id="sub-deskripsi-about"> {{ (isset($result->deskripsi)) ? $result->deskripsi_content : '' }}</textarea>
            </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
            <div class="form-group">
                <label for="email"> Upload Image </label>
                <input type="file" class="form-control" id="image">
            </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
            <div class="form-group">
                <button class="btn btn-primary" id="submit-about">Update</button>
            </div>
            </div>
        </div>
        </div><!-- /.card-body -->
    </div>
    </section>
</div>


<script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/7.3.0/tinymce.min.js"></script>
<!-- /.row (main row) -->
@endsection

@section('internal.layouts.script')
<script>
    
    $('#submit-about').click(function(){
        let $post = {};
            $post['title'] = $('#title-about').val();
            $post['keyword'] = $('#deskripsi-about').val();
            $post['deskripsi'] = $('#sub-deskripsi-about').val();
            $post['_token'] = '{{ csrf_token() }}';

            var deskripsi = tinymce.get('deskripsi-about').getContent(); // Get the content from the editor
            var sub_deskripsi = tinymce.get('sub-deskripsi-about').getContent(); // Get the content from the editor


            var formData = new FormData();
            var file = $('#image')[0].files[0];
            formData.append('image', file);
            formData.append('title', $('#title-about').val());
            formData.append('deskripsi',  deskripsi);
            formData.append('sub-deskripsi',  sub_deskripsi);
            formData.append('_token', "{{ csrf_token() }}");

        $.ajax({
            url : `{{ route('adm.about.update') }}`,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success : function(data){
                if(data.status){
                    swal({
                        title: "Good job!",
                        text: "Data Berhasil Diupdate",
                        icon: "success",
                    });
                    setTimeout(function() {
                        location.reload(); 
                    }, 1000); 
                }
            }
        })
    });

    tinymce.init({
        selector: "textarea",
        plugins: [
            "advlist", "anchor", "autolink", "charmap", "code", "fullscreen",
            "help", "image", "insertdatetime", "link", "lists", "media",
            "preview", "searchreplace", "table", "visualblocks",
        ],
        force_br_newlines: true,
        force_p_newlines: false,
        forced_root_block: 'p', // Use 'p' or 'div' for block elements, no need for an object
        toolbar: "undo redo | styles | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image",
        content_style: "p { margin: 5px 0; }", // You can apply your margin style here
    });

</script>
@endsection