<section id="testimoni" class="testimonials section light-background">
    <!-- Section Title -->
    <div class="container section-title" data-aos="fade-up">
        <h2>Testimoni</h2>
        <p>{!! $deskripsi_testimoni !!}</p>
    </div>
    <!-- End Section Title -->

    <div class="container" data-aos="fade-up" data-aos-delay="100">
        <div class="swiper init-swiper" data-speed="600" data-delay="5000" data-breakpoints='{ "320": { "slidesPerView": 1, "spaceBetween": 40 }, "1200": { "slidesPerView": 3, "spaceBetween": 40 } }'>
            <script type="application/json" class="swiper-config">
                {
                    "loop": true,
                    "speed": 500,
                    "autoplay": {
                        "delay": 4000
                    },
                    "slidesPerView": "auto",
                    "pagination": {
                        "el": ".swiper-pagination",
                        "type": "bullets",
                        "clickable": true
                    },
                    "breakpoints": {
                        "320": {
                            "slidesPerView": 1,
                            "spaceBetween": 40
                        },
                        "1200": {
                            "slidesPerView": 3,
                            "spaceBetween": 20
                        }
                    }
                }
            </script>
            <div class="swiper-wrapper">
            @foreach($result_testimoni as $k => $v)
            <div class="swiper-slide">
                <div class="testimonial-item">
                    <p>
                        <i class="bi bi-quote quote-icon-left"></i>
                        <span>{!! $v->testimoni !!}</span>
                        <i class="bi bi-quote quote-icon-right"></i>
                    </p>
                   @if(empty($v->foto))
                        <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRKaiKiPcLJj7ufrj6M2KaPwyCT4lDSFA5oog&s" class="testimonial-img" alt="">
                    @else
                        <img src="{{ asset('uploads/'.$v->foto) }}" class="testimonial-img" alt="" />
                    @endif
                    <h3>{{ $v->user_testimoni }}</h3>
                    <h4>{{ $v->title_testimoni }}</h4>
                </div>
            </div>
            @endforeach
            <!-- End testimonial item -->

        </div>
        <div class="swiper-pagination"></div>
    </div>
</section>