<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Symfony\Component\HttpFoundation\Response;

class CheckSession
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $id_user_session = Session::get('id_user');
        $username_session = Session::get('username');

        if(empty($id_user_session) || empty($username_session)){
            return redirect()->route('adm.login');
        }

        return $next($request);
    }
}
