<?php

namespace App\Http\Controllers;

use App\Models\MDataSEO;
use Illuminate\Http\Request;
use App\Helpers\MyHelper;

class SEOController extends Controller
{
    public function index()
    {
        $data['result'] = MDataSEO::first();
        return view('internal.seo.index', $data);
    }

    public function save(Request $request)
    {
        $title = $request->title;
        $deskripsi = $request->deskripsi;
        $keyword = $request->title;

        $check_seo = MDataSEO::truncate();
        $data_create = MDataSEO::create([
            "title_meta" => $title,
            "deskripsi_meta" => $deskripsi,
            "keyword_meta" => $keyword,
        ]);
        
        if($data_create){
            return Response()->json([
                "status" => true, 
                "message" => "Berhasil menyimpan data SEO"
            ]);
        }
    }

    public function updateSEO(Request $request){
        $title = $request->title;
        $keyword = $request->keyword;
        $deskripsi = $request->deskripsi;

        $data = MDataSEO::first(); // Get the first record or null if none exist
        $id = $data->id;

        $imageName = null; // Initialize the image variable
        if ($request->hasFile('image')) {
            // Get the uploaded file
            $image = $request->file('image');
            
            // Generate a unique name for the image
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            
            // Move the image to the 'uploads' folder (you may want to store it in 'storage')
            $image->move(public_path('uploads'), $imageName);
        }

        if (empty($data)) {
            // If no record exists, create a new one
            MDataSEO::create([
                "title_meta" => $title,
                "deskripsi_meta" => $deskripsi,
                "keyword_meta" => $keyword,
                "icon" => $imageName, // Save the image name
            ]);
        } else {
            // Ensure we only update the image if it was uploaded
            MDataSEO::where('id', $data->id)->update([
                "title_meta" => $title,
                "deskripsi_meta" => $deskripsi,
                "keyword_meta" => $keyword,
                "icon" => $imageName ? $imageName : $data->icon, // Keep the old image if no new one is uploaded
            ]);
        }

        // Return a success response
        return response()->json([
            "status" => true,
            "message" => "Data successfully saved"
        ]);

    }
}
