<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class InUserController extends Controller
{
    public function index()
    {
        $data['result_data'] = DB::table('tbl_m_users_access')->where('is_aktif',1)->get();
        return view('internal.user-akses.index', $data);
    }

    /** proses hapus data */
    public function deleteUser(Request $request)
    {
        $id = $request->id;
        $proses_delete  = DB::table('tbl_m_users_access')->where('id_m_users', $id)->update([
            "is_aktif" => 0
        ]);

        if($proses_delete){
            return response()->json(['status' => true, 'message' => 'Data berhasil dihapus']);
        }else{
            return response()->json(['status' => false]);
        }
    }

    public function editRow(Request $request)
    {
        $id = $request->id;
        $row_data  = DB::table('tbl_m_users_access')->where('id_m_users', $id)->first();
        return view('internal.user-akses.edit', compact('row_data'));
    }

    public function tambahData(Request $request)
{
    $username = $request->username;
    $password = $request->password;

    // Regex untuk validasi password
    $regex = '/^(?=.*[A-Z])(?=.*\d).{8,}$/'; // Menggunakan regex yang benar
    if (preg_match($regex, $password)) {
        // Hash password menggunakan bcrypt yang lebih aman
        $hashedPassword = hash('sha256',$password); // Menggunakan bcrypt untuk hashing password

        // Melakukan proses insert data ke database
        $proses_insert = DB::table('tbl_m_users_access')->insert([
            "username" => $username,
            "password" => $hashedPassword,
            "is_aktif" => 1
        ]);

        if ($proses_insert) {
            return response()->json(['status' => true, 'message' => 'Data berhasil ditambahkan']);
        } else {
            return response()->json(['status' => false, 'message' => 'Gagal menambahkan data']);
        }
    } else {
        // Jika password tidak memenuhi kriteria
        return response()->json(['status' => false, 'message' => 'Password harus mengandung minimal 8 karakter, minimal 1 huruf kapital, dan minimal 1 angka']);
    }
}


    public function updatePassword(Request $request)
    {
        $password = $request->password;
        $password_ulang = $request->password_baru;

        // Memastikan password dan password ulang sama
        if ($password != $password_ulang) {
            return response()->json(['status' => false, 'message' => 'Password baru dan ulang password tidak sama']);
        }

        // Regex untuk validasi password
        $regex = '/^(?=.*[A-Z])(?=.*\d).{8,}$/'; // Menggunakan regex yang benar
        if (preg_match($regex, $password)) {
            // Hash password menggunakan bcrypt
            $hashedPassword = hash('sha256',$password); // Menggunakan bcrypt untuk keamanan yang lebih baik
            // dd($hashedPassword);

            // Melakukan proses update password di database
            $proses_update = DB::table('tbl_m_users_access')
                                ->where('id_m_users', $request->id)
                                ->update(['password' => $hashedPassword]);

            // Mengecek apakah update berhasil
            if ($proses_update) {
                return response()->json(['status' => true, 'message' => 'Password berhasil diubah']);
            } else {
                // Jika update gagal
                return response()->json(['status' => false, 'message' => 'Gagal mengubah password. Silakan coba lagi.']);
            }
        } else {
            // Jika password tidak memenuhi kriteria
            return response()->json(['status' => false, 'message' => 'Password tidak sesuai kriteria yang ditentukan']);
        }
    }

}
