<?php

namespace App\Http\Controllers;

use App\Models\MDataDeskripsiTestimoni;
use App\Models\MDataTestimoni;
use Illuminate\Http\Request;

class InTestimonialController extends Controller
{
    public function index()
    {
        $deskripsi = MDataDeskripsiTestimoni::all();
        $data['deskripsi'] = (isset($deskripsi[0]->deskripsi)) ? $deskripsi[0]->deskripsi : '';
        $data['result'] = MDataTestimoni::all();
        return view('internal.testimoni.index', $data);
    }

    public function deleteTestimoni(Request $request)
    {
        $id = $request->id;
        $exec = MDataTestimoni::where('id_m_testimoni', $id)->delete();
        if($exec){
            return response()->json([
                "status" =>  true, 
                "message" => "Data Berhasil dihapus"
            ]);
        }else{
            return response()->json([
                "status" =>  false, 
                "message" => "Data Gagal dihapus"
            ]);
        }
    }

    public function store(Request $request)
    {
        $testimoni  = $request->testimoni;
        $user_testimoni  = $request->nama_testimoni;
        $title_testimoni  = $request->title_testimoni;

        $filePath = null;
        if ($request->hasFile('foto_testimoni')) {
            $file = $request->file('foto_testimoni');
            // $filePath = $file->store('uploads/testimoni', 'public');  // Store the file in the public disk
            $filePath = 'testimoni/' . time() . '_' . $file->getClientOriginalName();
            // Move the file to the public folder
            $file->move(public_path('uploads/testimoni'), $filePath); // 'uploads' is the folder inside public/
        }

        $data = MDataTestimoni::create([
            'testimoni' => $testimoni,
            'user_testimoni' => $user_testimoni,
            'title_testimoni' => $title_testimoni,
            "created_date" => date('Y-m-d H:i:s'),
            "foto" => $filePath
        ]);

        if($data){
            return response()->json([
                "status" =>  true, 
                "message" => "Data Berhasil ditambahkan"
            ]);
        }else{
            return response()->json([
                "status" =>  false, 
                "message" => "Data Gagal ditambahkan"
            ]);
        }
    }

    public function updateDeskripsi(Request $request)
    {
        $content = $request->id;
        MDataDeskripsiTestimoni::truncate();
        MDataDeskripsiTestimoni::create([
            "deskripsi" => $content
        ]);

        return response()->json([
            "status" =>  true,
            "message" => "Data Berhasil diupdate"
        ]);
    }

    public function edit(Request $request)
    {
        $id = $request->id;
        $data = MDataTestimoni::where('id_m_testimoni', $id)->first();
        return Response()->json($data);
    }

    public function updateTestimoni(Request $request)
    {
        $id = $request->id;
        $nama = $request->nama_testimoni;
        $title = $request->title_testimoni;
        $testimoni = $request->testimoni;

        $filePath = MDataTestimoni::where('id_m_testimoni', $id)->first()->foto;
        if ($request->hasFile('foto_testimoni')) {
            $file = $request->file('foto_testimoni');
            // $filePath = $file->store('uploads/testimoni', 'public');  // Store the file in the public disk
            $filePath = 'testimoni/' . time() . '_' . $file->getClientOriginalName();
            // Move the file to the public folder
            $file->move(public_path('uploads/testimoni'), $filePath); // 'uploads' is the folder inside public/
        }

        $update = MDataTestimoni::where('id_m_testimoni', $id)->update([
            "user_testimoni" => $nama,
            "title_testimoni" => $title,
            "testimoni" => $testimoni,
            "created_date" => date('Y-m-d H:i:s'),
            "foto" => $filePath,
        ]);

        if($update){
            return response()->json([
                "status" =>  true, 
                "message" => "Data Berhasil diupdate"
            ]);
        }else{
            return response()->json([
                "status" =>  false, 
                "message" => "Data Gagal diupdate"
            ]);
        }
    }
}
