<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\MDataTrenEmas;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class InHargaTrenEmasController extends Controller
{
    public function index()
    {
        $data['result'] = MDataTrenEmas::orderBy('id_trx_tren_emas', 'desc')->get();
        return view('internal.harga-tren-emas.index', $data);
    }

    public function hapusHargaEmas(Request $request)
    {
        $id = $request->id;
        $data = DB::table('tbl_tren_emas')->where('id_trx_tren_emas', $id)->delete();
        if($data){
            return response()->json([
                'status' => true,
                'message' => 'Data berhasil dihapus',
            ]);
        }
    }

    public function updateHargaTrenEmas(Request $request)
    {
        date_default_timezone_set('Asia/Jakarta');
        $date = $request->datetime_harga.":00";
        
        $unixTimestamp = (string)( (strtotime($date) * 1000) + + (7 * 60 * 60 * 1000));
        $harga = $request->harga_emas;
        $tanggal = $request->datetime_harga;
        
        $check_tanggal = MDataTrenEmas::where('update_date', $tanggal)->first();
        if(empty($check_tanggal)){

            $exec = DB::insert('insert into tbl_tren_emas (update_date, tanggal_timestamp, harga, create_date) values (?, ?, ?, ?)', [$tanggal,$unixTimestamp, $harga, date('Y-m-d H:i:s')]);

            if($exec){
                return Response()->json(['status' => true, 'message' => 'Data berhasil ditambahkan']);
            }else{
                return Response()->json(['status' => false, 'message' => 'Data gagal ditambahkan']);
            }
            
        }
    }
}
