<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use Illuminate\Support\Facades\DB;

class InHargaEmasController extends Controller
{
    public function index()
    {
        $data['result'] = DB::select("SELECT id_trx_harga_emas, harga, berat, update_date FROM tbl_trx_harga_emas ORDER BY update_date DESC, berat ASC");
        
        return view('internal.harga-emas.index', $data);
    }

    public function uploadHargaEmas(Request $request)
    {   
      // Ambil file Excel yang diupload
         $file = $request->file('file');
         $datetime = $request->input('datetime_harga');
        
      // Baca file Excel menggunakan PhpSpreadsheet
         $spreadsheet = IOFactory::load($file->getPathname());
 
      // Ambil data dari sheet pertama
         $sheet = $spreadsheet->getActiveSheet();
         
       // Ambil semua data dalam bentuk array
         $data = $sheet->toArray();
         $data_count_trx = DB::select("select trx from tbl_trx_harga_emas order by trx desc limit 1");
         $trx = isset($data_count_trx[0]->trx) ? $data_count_trx[0]->trx + 1 : 1;

         foreach ($data as $row) {
            
            $kolom_1 = $row[0]; 
            $kolom_2 = $row[1];  

            if($kolom_1 != 'Berat' && $kolom_2 != 'Harga'){
                DB::table('tbl_trx_harga_emas')->insert([
                    "berat" => $kolom_1,
                    "harga" => preg_replace('/Rp\s|,/', '', $kolom_2),
                    "trx"   =>  $trx,
                    "update_date" => date('Y-m-d H:i', strtotime($datetime))
                ]);
            }
        }
 
        return response()->json([
            'status' => true,
            'message' => 'Data berhasil diupload',
        ]);
    }

    public function hapusHargaEmas(Request $request)
    {
        $id = $request->id;
        $data = DB::table('tbl_trx_harga_emas')->where('id_trx_harga_emas', $id)->delete();
        if($data){
            return response()->json([
                'status' => true,
                'message' => 'Data berhasil dihapus',
            ]);
        }
    }

     public function trenEmas()
    {
        $data = DB::SELECT("SELECT tanggal_timestamp, harga FROM tbl_tren_emas tthe ORDER BY update_date ASC");
        $dataArray = collect($data)->map(function($item) {
            return [
                (int) $item->tanggal_timestamp, // index 0
                (int) $item->harga, // index 1
            ];
        })->toArray();

        return $dataArray;
    }

    public function grabHargaEmas()
    {
        $data = [[1262596020000,408000],[1262683680000,410000],[1262761260000,410000],[1262857500000,412000],[1262943420000,410000],[1263198600000,413000],[1263283680000,410000],[1263366000000,409000],[1263453000000,410000],[1263544200000,408000],[1263803940000,406000],[1263886860000,410000],[1263978240000,410000],[1264058580000,408000],[1264144020000,404000],[1264406400000,404000],[1264496640000,404000],[1264576080000,404000],[1264667880000,403000],[1264749180000,403000],[1265014620000,403000],[1265098740000,405000],[1265183100000,406000],[1265273040000,404000],[1265358660000,401000],[1265619240000,400000],[1265702100000,401000],[1265785440000,402000],[1265873160000,401000],[1265964600000,403000],[1266225120000,402000],[1266309360000,403000],[1266391200000,406000],[1266484380000,401000],[1266563520000,401000],[1266826740000,408000],[1266917160000,402000],[1266995220000,401000],[1267089060000,400000],[1267427340000,404000],[1267521600000,401000],[1267602960000,405000],[1267691880000,406000],[1267773300000,403000],[1268031840000,404000],[1268125440000,400000],[1268211120000,399000],[1268291400000,398000],[1268377740000,398000],[1268639460000,397000],[1268814960000,400000],[1268902500000,398000],[1269247200000,396000],[1269332400000,395000],[1269419220000,395000],[1269507240000,394000],[1269595200000,395000],[1269850260000,396000],[1269932760000,396000],[1270026720000,395000],[1270111080000,397000],[1270459560000,399000],[1270539360000,399000],[1270545780000,399000],[1270632480000,399000],[1270710420000,401000],[1270804800000,403000],[1271057640000,408000],[1271143680000,403000],[1271228940000,401000],[1271321040000,401000],[1271407380000,401000],[1271661120000,397000],[1271753820000,398000],[1271836800000,398000],[1271926620000,399000],[1272011520000,399000],[1272270000000,402000],[1272358800000,401000],[1272441360000,404000],[1272530880000,404000],[1272618360000,406000],[1272874140000,407000],[1272963660000,408000],[1273048140000,405000],[1273131780000,411000],[1273223580000,420000],[1273223760000,422000],[1273238160000,422000],[1273482000000,423000],[1273495080000,417000],[1273564440000,417000],[1273655340000,424000],[1273828020000,426000],[1274085360000,429000],[1274170140000,426000],[1274257800000,425000],[1274347080000,417000],[1274433300000,415000],[1274684880000,420000],[1274778180000,424000],[1274863140000,427000],[1274948700000,429000],[1275295800000,428000],[1275386940000,425000],[1275465300000,427000],[1275554040000,428000],[1275572040000,425000],[1275636840000,421000],[1275903480000,427000],[1275986100000,434000],[1276073880000,433000],[1276158840000,430000],[1276246560000,427000],[1276506240000,428000],[1276590420000,424000],[1276678920000,428000],[1276765860000,427000],[1276845300000,431000],[1277107140000,434000],[1277197020000,423000],[1277278980000,427000],[1277365080000,424000],[1277453520000,425000],[1277715540000,430000],[1277802840000,424000],[1277889300000,426000],[1277974620000,427000],[1278055620000,417000],[1278059160000,417000],[1278313020000,418000],[1278405720000,417000],[1278492000000,416000],[1278581220000,418000],[1278659580000,415000],[1278918540000,418000],[1279012500000,415000],[1279098540000,418000],[1279178760000,417000],[1279268940000,417000],[1279529280000,414000],[1279615680000,412000],[1279701780000,413000],[1279784040000,412000],[1279870320000,414000],[1280136060000,413000],[1280214120000,411000],[1280306820000,409000],[1280394600000,410000],[1280480700000,410000],[1280737020000,410000],[1280826300000,410000],[1280906040000,411000],[1280992740000,412000],[1281078420000,412000],[1281345000000,413000],[1281425280000,412000],[1281510180000,413000],[1281600840000,414000],[1281688560000,418000],[1281948300000,418000],[1282119420000,420000],[1282201740000,421000],[1282295340000,421000],[1282554000000,420000],[1282641000000,418000],[1282722240000,420000],[1282806600000,422000],[1282899060000,423000],[1283154600000,422000],[1283245980000,422000],[1283325060000,426000],[1283417100000,425000],[1283502180000,426000],[1283765400000,425000],[1283844420000,424000],[1283932080000,427000],[1284448320000,426000],[1284533940000,431000],[1284621420000,430000],[1284712140000,434000],[1284969300000,433000],[1285055520000,433000],[1285142760000,436000],[1285230420000,437000],[1285314600000,436000],[1285571160000,438000],[1285666020000,437000],[1285751280000,442000],[1285831800000,442000],[1285920240000,441000],[1286186040000,443000],[1286269380000,442000],[1286355480000,452000],[1286409600000,450000],[1286456400000,453000],[1286496000000,448000],[1286755200000,452000],[1286841600000,453000],[1286928000000,453000],[1287014400000,460000],[1287100800000,460000],[1287360000000,455000],[1287446400000,459000],[1287532800000,448000],[1287619200000,451000],[1287705600000,445000],[1287964800000,447000],[1288051200000,449000],[1288137600000,449000],[1288224000000,445000],[1288310400000,450000],[1288569600000,455000],[1288656000000,452000],[1288828800000,451000],[1288915200000,462000],[1289174400000,464000],[1289260800000,466000],[1289347200000,464000],[1289433600000,465000],[1289520000000,465000],[1289779200000,458000],[1289865600000,455000],[1290038400000,452000],[1290124800000,456000],[1290384000000,455000],[1290470400000,455000],[1290556800000,459000],[1290643200000,462000],[1290729600000,460000],[1290988800000,457000],[1291075200000,462000],[1291165200000,467000],[1291168800000,469000],[1291211160000,469000],[1291248000000,468000],[1291334400000,468000],[1291593600000,474000],[1291766400000,471000],[1291852800000,466000],[1291939200000,467000],[1292198400000,466000],[1292284800000,470000],[1292371200000,470000],[1292457600000,465000],[1292544000000,464000],[1292803200000,467000],[1292889600000,468000],[1292976000000,468000],[1293062400000,468000],[1293408000000,466000],[1293494400000,468000],[1293580800000,473000],[1293667200000,474000],[1293753600000,471000],[1294012800000,474000],[1294099200000,473000],[1294185600000,464000],[1294272000000,463000],[1294358400000,461000],[1294617600000,462000],[1294704000000,466000],[1294790400000,469000],[1294876800000,469000],[1294963200000,466000],[1295222400000,464000],[1295308800000,464000],[1295395200000,467000],[1295481600000,466000],[1295568000000,462000],[1295827200000,462000],[1295913600000,460000],[1296000000000,460000],[1296086400000,461000],[1296172800000,458000],[1296432000000,460000],[1296464400000,460000],[1296518400000,460000],[1296604800000,461000],[1296777600000,462000],[1297036800000,462000],[1297123200000,461000],[1297209600000,463000],[1297296000000,462000],[1297382400000,462000],[1297641600000,462000],[1297814400000,464000],[1297900800000,464000],[1297987200000,465000],[1298019600000,465000],[1298246400000,470000],[1298332800000,472000],[1298419200000,470000],[1298505600000,473000],[1298592000000,470000],[1298851200000,472000],[1298937600000,469000],[1299024000000,475000],[1299110400000,476000],[1299196800000,471000],[1299456000000,475000],[1299542400000,475000],[1299628800000,474000],[1299715200000,472000],[1299747600000,472000],[1299801600000,467000],[1300060800000,472000],[1300147200000,471000],[1300233600000,462000],[1300264200000,463000],[1300320000000,462000],[1300406400000,468000],[1300665600000,471000],[1300752000000,471000],[1300838400000,469000],[1300924800000,472000],[1301011200000,472000],[1301270400000,468000],[1301356800000,467000],[1301443200000,467000],[1301529600000,469000],[1301616000000,471000],[1301875200000,470000],[1301961600000,471000],[1302048000000,476000],[1302134400000,476000],[1302220800000,476000],[1302480000000,480000],[1302566400000,476000],[1302652800000,476000],[1302739200000,476000],[1302825600000,480000],[1303084800000,483000],[1303171200000,485000],[1303257600000,486000],[1303344000000,487000],[1303689600000,488000],[1303736400000,488000],[1303776000000,485000],[1303862400000,488000],[1303948800000,493000],[1304035200000,495000],[1304294400000,497000],[1304380800000,492000],[1304467200000,490000],[1304553600000,485000],[1304640000000,475000],[1304899200000,480000],[1304985600000,483000],[1305072000000,485000],[1305158400000,482000],[1305244800000,481000],[1305504000000,478000],[1305676800000,478000],[1305763200000,480000],[1305849600000,480000],[1306108800000,485000],[1306195200000,485000],[1306281600000,488000],[1306368000000,489000],[1306454400000,488000],[1306713600000,491000],[1306744200000,491000],[1306800000000,491000],[1306886400000,489000],[1307318400000,491000],[1307404800000,490000],[1307491200000,489000],[1307577600000,488000],[1307664000000,490000],[1307923200000,486000],[1308009600000,484000],[1308096000000,486000],[1308182400000,487000],[1308268800000,489000],[1308528000000,493000],[1308614400000,492000],[1308700800000,494000],[1308787200000,495000],[1308873600000,488000],[1309132800000,483000],[1309219200000,484000],[1309392000000,486000],[1309478400000,483000],[1309737600000,479000],[1309824000000,480000],[1309910400000,484000],[1309996800000,487000],[1310083200000,488000],[1310342400000,491000],[1310428800000,494000],[1310515200000,498000],[1310601600000,505000],[1310688000000,504000],[1310947200000,505000],[1311033600000,509000],[1311120000000,505000],[1311206400000,508000],[1311292800000,505000],[1311552000000,511000],[1311638400000,511000],[1311724800000,512000],[1311811200000,509000],[1311897600000,510000],[1312156800000,510000],[1312243200000,510000],[1312329600000,518000],[1312416000000,522000],[1312502400000,516000],[1312549200000,520000],[1312761600000,530000],[1312804800000,534000],[1312848000000,540000],[1312884000000,548000],[1312891200000,555000],[1312934400000,553000],[1313020800000,563000],[1313107200000,550000],[1313366400000,544000],[1313409600000,547000],[1313452800000,554000],[1313625600000,558000],[1313668800000,560000],[1313712000000,570000],[1313755200000,575000],[1313971200000,585000],[1314057600000,594000],[1314144000000,576000],[1314259200000,552000],[1314316800000,556000],[1314694800000,575000],[1315180800000,590000],[1315213200000,590000],[1315353600000,590000],[1315440000000,577000],[1315526400000,590000],[1315785600000,588000],[1315904400000,578000],[1315915200000,584000],[1315990800000,588000],[1316004300000,594000],[1316077200000,594000],[1316131200000,580000],[1316390400000,596000],[1316476800000,590000],[1316563200000,605000],[1316649600000,595000],[1316768400000,585000],[1316995200000,575000],[1317081600000,575000],[1317168000000,575000],[1317254400000,575000],[1317340800000,575000],[1317600000000,570000],[1317686400000,575000],[1317772800000,572000],[1317859200000,574000],[1317945600000,575000],[1318204800000,575000],[1318323600000,580000],[1318410000000,576000],[1318496400000,580000],[1318550400000,575000],[1318838400000,575000],[1318928400000,571000],[1319014800000,570000],[1319101200000,568000],[1319187600000,565000],[1319446800000,570000],[1319533200000,560000],[1319619600000,570000],[1319706000000,575000],[1319792400000,580000],[1320051600000,573000],[1320134400000,565000],[1320224400000,567000],[1320310800000,572000],[1320397200000,578000],[1320656400000,575000],[1320742800000,584000],[1320829200000,583000],[1320915600000,576000],[1321000200000,573500],[1321006500000,579500],[1321260300000,588000],[1321346400000,580000],[1321431600000,582000],[1321517700000,580000],[1321609200000,572000],[1321863600000,572000],[1321950000000,565000],[1322035200000,570000],[1322121600000,570000],[1322179200000,573000],[1322467800000,573000],[1322554500000,580000],[1322640600000,585000],[1322727300000,587000],[1322813700000,578000],[1323072900000,584000],[1323160200000,572000],[1323245400000,573000],[1323332400000,576000],[1323419400000,570000],[1323678600000,569000],[1323765000000,566000],[1323852000000,562000],[1323936600000,559000],[1324023300000,650000],[1324023600000,560000],[1324284300000,564000],[1324339200000,565000],[1324455300000,569000],[1324542600000,568000],[1324628100000,567000],[1324974600000,563000],[1325061000000,563000],[1325146200000,557000],[1325233800000,555000],[1325462400000,555000],[1325548800000,559000],[1325665800000,565000],[1325721600000,566000],[1325808000000,567000],[1326097800000,565000],[1326184200000,566000],[1326270600000,570000],[1326357000000,571000],[1326443400000,572000],[1326702600000,565000],[1326789000000,566000],[1326844800000,567000],[1326961800000,564000],[1327048200000,559000],[1327393800000,559000],[1327480200000,557000],[1327566600000,571000],[1327653000000,572000],[1327911300000,573000],[1328000400000,570000],[1328083200000,571000],[1328169600000,574000],[1328256000000,569000],[1328269500000,573000],[1328517000000,565000],[1328605200000,564000],[1328689800000,570000],[1328776200000,568000],[1328862000000,566000],[1329121800000,570000],[1329210000000,570000],[1329292800000,570000],[1329379200000,572000],[1329467400000,572000],[1329726600000,576000],[1329813000000,576000],[1329899400000,581000],[1329985800000,588000],[1330072200000,589000],[1330331400000,588000],[1330417800000,588000],[1330504200000,592000],[1330590600000,578000],[1330677000000,579000],[1330936200000,578000],[1331021700000,577000],[1331110800000,573000],[1331195400000,575000],[1331280900000,577000],[1331542800000,578000],[1331627400000,576000],[1331715600000,571000],[1331800200000,567000],[1331886600000,570000],[1332115200000,571000],[1332234000000,571500],[1332320400000,569000],[1332403200000,570000],[1332750600000,573000],[1332838800000,579000],[1332923400000,579000],[1333008000000,576000],[1333098000000,576000],[1333355400000,579000],[1333443600000,579000],[1333526400000,574000],[1333614600000,568000],[1333962000000,574000],[1334048400000,574000],[1334131200000,574000],[1334219400000,575000],[1334307600000,577000],[1334564100000,568000],[1334651400000,567000],[1334736000000,567000],[1334824200000,570000],[1335169800000,564500],[1335256200000,564500],[1335340800000,565000],[1335429000000,565000],[1335513600000,565500],[1335774600000,565000],[1335861000000,563000],[1335946800000,559000],[1336033800000,555000],[1336118400000,554000],[1336136400000,555000],[1336377600000,558000],[1336464000000,558000],[1336550400000,554000],[1336608000000,552000],[1336636800000,554000],[1336638600000,552000],[1336723200000,553000],[1336982400000,553000],[1336982700000,553000],[1337040000000,553000],[1337155200000,549500],[1337589000000,552500],[1337589600000,552500],[1337675400000,552500],[1337760000000,550500],[1337846400000,550500],[1337932800000,550500],[1337933100000,550500],[1338192000000,552000],[1338278400000,555000],[1338364800000,551000],[1338451200000,556000],[1338537600000,555000],[1338796800000,563000],[1338882000000,565000],[1338968400000,565000],[1339054800000,565000],[1339141200000,560000],[1339401600000,565000],[1339488000000,561000],[1339574400000,563000],[1339660800000,564000],[1339747200000,566000],[1340005500000,566000],[1340093700000,567000],[1340179200000,565000],[1340265600000,563000],[1340352000000,557000],[1340612400000,557000],[1340697600000,559000],[1340784000000,558000],[1340870400000,558000],[1340956800000,555000],[1341217200000,562000],[1341302400000,558000],[1341390300000,565000],[1341475200000,560000],[1341561600000,559000],[1341820800000,555000],[1341909000000,556000],[1341964800000,555000],[1342081200000,554000],[1342167000000,551000],[1342167300000,551000],[1342396800000,559000],[1342483200000,559000],[1342569600000,555000],[1342684800000,551000],[1342771200000,554000],[1343031000000,554000],[1343088000000,554000],[1343203200000,555000],[1343291400000,560000],[1343378700000,564000],[1343635200000,565000],[1343723400000,565000],[1343807400000,562000],[1343896200000,561000],[1343982600000,559000],[1344241200000,562000],[1344326400000,563000],[1344412800000,563000],[1344499800000,563000],[1344588600000,562000],[1344844800000,563000],[1344931200000,560000],[1345017000000,558000],[1345104000000,558000],[1345707900000,570000],[1345795200000,574000],[1346056200000,575500],[1346112000000,572000],[1346228100000,572500],[1346314800000,570000],[1346400000000,571000],[1346659200000,581000],[1346746500000,583000],[1346832900000,583000],[1346918400000,583000],[1347004800000,584000],[1347265200000,599000],[1347351300000,596000],[1347436800000,596000],[1347525000000,595200],[1347610500000,607200],[1347868500000,608200],[1347955200000,596200],[1348041600000,601200],[1348099200000,605200],[1348214400000,604200],[1348473600000,604200],[1348560000000,604200],[1348645500000,604200],[1348732800000,604200],[1348790400000,610200],[1349078400000,605200],[1349164800000,609200],[1349222400000,607200],[1349308800000,609200],[1349395200000,614200],[1349654400000,610200],[1349740800000,609200],[1349827200000,606200],[1349913600000,606200],[1350000000000,609200],[1350259200000,603200],[1350345600000,603200],[1350432000000,606200],[1350549000000,604200],[1350633600000,601200],[1350892800000,594200],[1350907200000,598200],[1350981000000,600200],[1351067400000,596200],[1351152000000,596200],[1351497600000,597200],[1351584000000,595200],[1351670400000,596200],[1351756800000,599200],[1351844100000,599200],[1352103300000,594200],[1352190600000,594200],[1352246400000,598200],[1352289600000,602200],[1352332800000,602200],[1352419200000,605200],[1352707200000,606200],[1352797200000,602000],[1352797500000,602200],[1352880000000,602200],[1353312000000,599200],[1353398400000,602200],[1353484800000,602200],[1353571200000,602200],[1353657600000,602200],[1353888000000,606200],[1354005000000,606200],[1354089600000,604200],[1354176000000,598200],[1354264200000,601200],[1354521600000,600200],[1354579200000,600200],[1354665600000,597200],[1354782000000,597200],[1354869000000,599200],[1355097600000,602200],[1355213700000,604200],[1355299200000,604200],[1355385600000,604200],[1355473800000,599200],[1355731200000,601200],[1355819400000,602200],[1355904000000,598200],[1355991300000,597200],[1356076800000,591200],[1356508800000,598200],[1356595200000,601200],[1356681600000,604200],[1357113600000,599200],[1357200000000,605200],[1357286400000,597200],[1357546500000,601200],[1357632600000,598200],[1357719600000,600200],[1357804800000,597200],[1357892400000,599200],[1358153100000,598200],[1358237700000,600200],[1358325000000,606200],[1358411400000,603200],[1358467200000,604200],[1358756400000,604200],[1358844600000,604200],[1358928000000,603200],[1359101400000,600200],[1359360000000,599200],[1359448200000,599200],[1359532800000,601200],[1359619800000,603200],[1359705600000,599200],[1359965400000,599200],[1360022400000,599200],[1360054260000,599200],[1360108800000,599200],[1360195200000,600200],[1360281600000,600200],[1360570800000,596200],[1360657800000,591200],[1360741500000,592200],[1360829700000,591200],[1360915800000,590200],[1361176200000,588200],[1361262000000,588200],[1361348100000,587200],[1361434800000,581200],[1361522700000,582200],[1361781000000,585200],[1361868900000,587200],[1361953200000,592200],[1362039000000,590200],[1362125700000,586200],[1362384600000,586200],[1362473100000,586200],[1362558600000,586200],[1362643800000,586200],[1362729300000,586200],[1362988800000,584200],[1363161600000,585200],[1363249800000,584000],[1363305600000,584000],[1363594800000,581000],[1363681800000,582000],[1363767600000,583000],[1363855500000,581000],[1363942800000,582000],[1364198400000,579000],[1364288400000,577000],[1364372400000,577000],[1364459700000,577000],[1364774400000,574000],[1364893200000,574000],[1364976900000,571000],[1365062400000,569000],[1365148800000,566000],[1365410400000,569000],[1365495900000,567000],[1365583200000,568000],[1365669000000,564000],[1365754200000,565000],[1366012800000,563000],[1366102800000,561000],[1366187400000,561000],[1366272900000,561000],[1366359300000,561000],[1366619400000,551000],[1366706700000,555000],[1366792200000,555000],[1366878300000,557000],[1366963200000,557000],[1367223600000,553000],[1367311800000,553000],[1367397000000,552000],[1367483400000,550000],[1367568000000,551000],[1367829000000,552000],[1367916600000,551000],[1368001800000,549000],[1368174000000,549000],[1368433800000,545000],[1368521400000,543000],[1368606000000,539000],[1368690600000,537000],[1368780600000,532000],[1369039800000,532000],[1369128000000,533000],[1369209600000,533000],[1369297200000,533000],[1369382400000,536000],[1369644300000,536000],[1369731000000,536000],[1369816200000,535000],[1369901400000,538000],[1369989000000,539000],[1370247600000,538000],[1370335800000,541000],[1370420100000,539000],[1370592000000,542000],[1370853000000,533000],[1370941200000,533000],[1371025800000,533000],[1371111600000,533000],[1371196800000,533000],[1371457800000,533000],[1371544200000,533000],[1371630600000,532000],[1371717000000,528000],[1371802800000,521000],[1372062000000,522000],[1372149900000,518000],[1372234500000,518000],[1372321800000,513000],[1372408200000,513000],[1372668300000,513000],[1372753800000,514000],[1372839300000,514000],[1372925400000,515000],[1373008200000,514000],[1373272200000,512000],[1373357400000,512000],[1373444400000,513000],[1373529600000,516000],[1373617200000,516000],[1373875200000,516000],[1373961300000,516000],[1374048000000,516000],[1374135000000,514000],[1374222300000,515000],[1374483000000,521000],[1374568200000,525000],[1374654300000,526000],[1374741300000,522000],[1374827700000,525000],[1375086600000,523000],[1375174500000,523000],[1375259400000,523000],[1375346400000,523000],[1375430400000,520000],[1376296800000,524000],[1376382600000,524000],[1376465400000,524000],[1376524800000,525000],[1376611200000,532000],[1376899800000,541000],[1376988600000,540000],[1377043200000,542000],[1377129600000,550000],[1377216000000,559000],[1377475200000,564000],[1377561600000,564000],[1377648000000,575000],[1377698400000,580000],[1377734400000,593000],[1377820800000,578000],[1378080000000,571000],[1378166400000,575000],[1378252800000,583000],[1378339200000,579000],[1378425600000,570000],[1378684800000,581000],[1378771200000,578000],[1378857600000,565000],[1378944000000,572000],[1379030400000,559000],[1379289600000,552000],[1379376000000,547000],[1379462400000,545000],[1379548800000,569000],[1379635200000,558000],[1379894400000,549000],[1379980800000,554000],[1380067200000,554000],[1380153600000,558000],[1380240000000,555000],[1380499200000,559000],[1380585600000,558000],[1380672000000,550000],[1380758400000,555000],[1380844800000,555000],[1381104000000,554000],[1381221000000,556000],[1381276800000,555000],[1381363200000,551000],[1381449600000,548000],[1381912200000,545000],[1381968000000,545000],[1382054400000,558000],[1382313600000,556000],[1382432400000,554000],[1382486400000,556000],[1382572800000,552000],[1382659200000,556000],[1382918400000,550000],[1383004800000,546000],[1383091200000,543000],[1383138000000,542000],[1383177600000,542000],[1383264000000,542000],[1383523200000,543000],[1383696000000,544000],[1383782400000,548000],[1383868800000,543000],[1384128000000,539000],[1384214400000,539000],[1384329600000,538000],[1384387200000,548000],[1384473600000,544000],[1384732800000,544000],[1384819200000,542000],[1384905600000,541000],[1384992000000,540000],[1385107200000,540000],[1385368200000,540000],[1385424000000,545000],[1385539200000,545000],[1385624400000,545000],[1385712600000,550000],[1385942400000,551000],[1386028800000,546000],[1386115200000,545000],[1386201600000,552000],[1386288000000,548000],[1386547200000,546000],[1386633600000,548000],[1386720000000,558000],[1386806400000,555000],[1386892800000,547000],[1387152000000,550000],[1387238400000,550000],[1387324800000,549000],[1387411200000,548000],[1387497600000,544000],[1387756800000,546000],[1387843200000,544000],[1388132100000,544000],[1388361600000,547000],[1388448000000,544000],[1388620800000,544000],[1388660700000,550000],[1388735880000,552000],[1388966400000,555000],[1389052800000,552000],[1389139200000,551000],[1389254400000,550000],[1389312000000,550000],[1389571200000,555000],[1389744000000,550000],[1389830400000,550000],[1389916800000,550000],[1390176000000,555000],[1390292100000,555000],[1390348800000,553000],[1390435200000,552000],[1390521600000,560000],[1390780800000,565000],[1390867200000,559000],[1390984200000,558000],[1391070600000,559000],[1391385600000,552000],[1391472000000,560000],[1391501700000,558000],[1391558400000,558000],[1391673600000,557000],[1391761800000,557000],[1391990400000,561000],[1392076800000,564000],[1392163200000,567000],[1392278700000,567000],[1392336000000,570000],[1392595200000,571000],[1392681600000,571000],[1392768000000,571000],[1392854400000,569000],[1392940800000,569000],[1393228800000,569000],[1393286400000,571000],[1393372800000,571000],[1393459200000,571000],[1393545600000,571000],[1393833900000,571000],[1393921800000,573000],[1393977600000,572000],[1394092680000,568000],[1394178960000,571000],[1394438400000,565000],[1394496000000,567000],[1394582400000,567000],[1394668800000,572000],[1394755200000,572000],[1395014400000,576000],[1395132300000,570000],[1395216600000,566000],[1395273600000,560000],[1395360000000,560000],[1395619200000,562000],[1395705600000,556000],[1395792000000,556000],[1395907500000,556000],[1395964800000,554000],[1396342560000,552000],[1396396800000,551000],[1396512900000,550000],[1396597800000,550000],[1396828800000,552000],[1396915200000,552000],[1397088000000,553000],[1397174400000,555000],[1397433600000,558000],[1397520000000,558000],[1397606400000,554000],[1397692800000,554000],[1398038400000,553000],[1398124800000,552000],[1398239700000,553000],[1398297600000,554000],[1398384000000,554000],[1398643200000,555000],[1398729600000,553000],[1398816000000,553000],[1398988800000,551000],[1399248000000,557000],[1399334400000,557000],[1399420800000,557000],[1399507200000,549000],[1399593600000,550000],[1399852800000,549000],[1399939200000,550000],[1400025600000,549000],[1400198400000,549000],[1400457600000,549000],[1400544000000,546000],[1400630400000,550000],[1400716800000,551000],[1400803200000,552000],[1401062400000,552000],[1401235200000,547000],[1401408000000,547000],[1401667200000,546000],[1401753600000,547000],[1401840000000,548000],[1401926400000,548000],[1402012800000,550000],[1402272000000,550000],[1402358400000,549000],[1402444800000,550000],[1402531200000,550000],[1402617600000,553000],[1402876800000,553000],[1402963200000,553000],[1403049600000,553000],[1403136000000,559000],[1403222400000,569000],[1403481600000,569000],[1403568000000,569000],[1403654400000,570000],[1403740800000,571000],[1403827200000,572000],[1404086400000,570000],[1404172800000,571000],[1404259200000,565000],[1404345600000,566000],[1404432000000,568000],[1404691200000,564000],[1404777600000,562000],[1404950400000,561000],[1405036800000,558000],[1405296000000,559000],[1405382400000,553000],[1405468800000,551000],[1405555200000,551000],[1405584600000,551000],[1405641600000,556000],[1405900800000,554000],[1405987200000,552000],[1406073600000,549000],[1406160000000,549000],[1406246400000,548000],[1407110400000,553000],[1407232800000,551000],[1407283200000,551000],[1407369600000,557000],[1407456000000,558000],[1407715200000,557000],[1407801600000,557000],[1407888000000,555000],[1407974400000,556000],[1408060800000,556000],[1408320000000,550000],[1408406400000,551000],[1408492800000,551000],[1408579200000,551000],[1408665600000,551000],[1408924800000,551000],[1409011200000,551000],[1409097600000,551000],[1409184000000,551000],[1409270400000,552000],[1409529600000,551000],[1409616000000,551000],[1409702400000,549000],[1409788800000,550000],[1409875200000,549000],[1410134400000,549000],[1410220800000,548000],[1410307200000,548000],[1410393600000,548000],[1410480000000,548000],[1410739200000,547000],[1410772320000,547000],[1410825600000,547000],[1410912000000,547000],[1410998400000,546000],[1411084800000,546000],[1411344000000,544000],[1411434000000,544000],[1411437600000,544000],[1411516800000,544000],[1411603200000,544000],[1411689600000,543000],[1411948800000,543000],[1412035200000,545000],[1412121600000,545000],[1412208000000,545000],[1412294400000,545000],[1412581680000,543000],[1412640000000,544000],[1412726400000,544000],[1412812800000,545000],[1412899200000,545000],[1413158400000,546000],[1413244800000,546000],[1413331200000,545000],[1413417600000,549000],[1413504000000,549000],[1413763200000,546000],[1413849600000,546000],[1413936000000,545000],[1414022400000,544000],[1414108800000,543000],[1414368000000,543000],[1414454400000,543000],[1414540800000,546000],[1414627200000,544000],[1414713600000,543000],[1414972800000,542000],[1415059200000,542000],[1415145600000,542000],[1415232000000,542000],[1415318400000,542000],[1415577600000,542000],[1415664000000,541000],[1415750400000,541000],[1415836800000,540000],[1415923200000,539000],[1416182400000,540000],[1416268800000,540000],[1416355200000,540000],[1416441600000,539000],[1416528000000,539000],[1416787200000,542000],[1416873600000,540000],[1416960000000,540000],[1417046400000,539000],[1417132800000,538000],[1417392000000,536000],[1417478400000,543000],[1417564800000,542000],[1417651200000,544000],[1417737600000,544000],[1417996800000,541000],[1418083200000,540000],[1418169600000,551000],[1418256000000,551000],[1418285400000,551000],[1418342400000,551000],[1418601600000,552000],[1418688000000,549000],[1418774400000,551000],[1418860800000,550000],[1418947200000,547000],[1419206400000,545000],[1419292800000,541000],[1419379200000,541000],[1419811200000,543000],[1419897600000,540000],[1419984000000,549000],[1420156800000,545000],[1420416000000,545000],[1420502400000,550000],[1420588800000,557000],[1420675200000,558000],[1420761600000,557000],[1421020800000,563000],[1421107200000,561000],[1421193600000,563000],[1421280000000,561000],[1421366400000,573000],[1421485200000,581000],[1421506800000,581000],[1421625600000,580000],[1421712000000,580000],[1421798400000,584000],[1421884800000,582000],[1421971200000,581000],[1422057600000,580000],[1422230400000,579000],[1422316800000,575000],[1422403200000,580000],[1422489600000,578000],[1422576000000,570000],[1422662400000,583000],[1422835200000,581000],[1422921600000,578000],[1423008000000,574000],[1423094400000,577000],[1423180800000,576000],[1423267200000,563000],[1423440000000,565000],[1423526400000,566000],[1423612800000,563000],[1423661400000,568000],[1423699200000,563000],[1423785600000,566000],[1423872000000,566000],[1424044800000,567000],[1424131200000,567000],[1424217600000,564000],[1424390400000,564000],[1424476800000,561000],[1424649600000,564000],[1424736000000,563000],[1424822400000,564000],[1424908800000,565000],[1424995200000,566000],[1425081600000,567000],[1425254400000,567000],[1425294000000,571000],[1425340800000,569000],[1425427200000,568000],[1425513600000,568000],[1425600000000,568000],[1425859200000,564000],[1425945600000,564000],[1426032000000,563000],[1426118400000,563000],[1426204800000,563000],[1426464000000,562000],[1426550400000,562000],[1426636800000,561000],[1426723200000,562000],[1426809600000,562000],[1427068800000,563000],[1427155200000,564000],[1427241600000,563000],[1427328000000,563000],[1427378400000,568000],[1427414400000,569000],[1427500800000,568000],[1427673600000,568000],[1427760000000,566000],[1427846400000,565000],[1427932800000,570000],[1428105600000,568000],[1428278400000,574000],[1428364800000,572000],[1428451200000,571000],[1428537600000,570000],[1428624000000,568000],[1428883200000,570000],[1428969600000,568000],[1429056000000,567000],[1429142400000,570000],[1429228800000,570000],[1429257600000,566000],[1429315200000,567000],[1429488000000,567000],[1429574400000,566000],[1429660800000,568000],[1429747200000,565000],[1429833600000,567000],[1429920000000,563000],[1430092800000,565000],[1430179200000,569000],[1430265600000,574000],[1430352000000,571000],[1430381400000,571000],[1430524800000,562000],[1430697600000,565000],[1430784000000,567000],[1430870400000,568000],[1430956800000,569000],[1431043200000,567000],[1431129600000,567000],[1431302400000,571000],[1431388800000,567000],[1431475200000,567000],[1431475260000,572000],[1431561600000,581000],[1431648000000,579000],[1431734400000,582000],[1431907200000,578000],[1432023480000,579000],[1432109460000,577000],[1432166400000,577000],[1432252800000,575000],[1432339200000,575000],[1432512000000,573000],[1432598400000,575000],[1432684800000,570000],[1432771200000,572000],[1432857600000,571000],[1432944000000,570000],[1433116800000,573000],[1433317680000,574000],[1433376000000,571000],[1433462400000,570000],[1433548800000,570000],[1433721600000,569000],[1433808000000,571000],[1433894400000,573000],[1433980800000,575000],[1434067200000,573000],[1434153600000,574000],[1434326400000,574000],[1434412800000,575000],[1434499200000,574000],[1434585600000,576000],[1434672000000,580000],[1434758400000,578000],[1434931200000,579000],[1435017600000,575000],[1435104000000,572000],[1435190400000,571000],[1435276800000,572000],[1435363200000,569000],[1435536000000,575000],[1435622400000,574000],[1435708800000,572000],[1435795200000,570000],[1435881600000,569000],[1435968000000,567000],[1436140800000,570000],[1436256000000,570000],[1436313600000,570000],[1436400000000,570000],[1436486400000,571000],[1436572800000,573000],[1436745600000,571000],[1436832000000,570000],[1436918400000,570000],[1437523200000,567000],[1437609600000,567000],[1437696000000,567000],[1437725580000,567000],[1437727860000,567000],[1437728100000,567000],[1437782400000,567000],[1437985560000,567000],[1438041600000,567000],[1438128000000,567000],[1438214400000,567000],[1438300800000,567000],[1438387200000,567000],[1438560000000,567000],[1438646400000,567000],[1438732800000,567000],[1438819200000,567000],[1438905600000,566000],[1438992000000,567000],[1439164800000,566000],[1439251200000,566000],[1439337600000,567000],[1439424000000,568000],[1439510400000,567000],[1439596800000,567000],[1439856000000,567000],[1439942400000,568000],[1440028800000,572000],[1440115200000,580000],[1440201600000,586000],[1440288000000,580000],[1440405060000,583000],[1440460800000,584000],[1440547200000,583000],[1440633600000,578000],[1440720000000,578000],[1440806400000,574000],[1440979200000,577000],[1441065600000,578000],[1441152000000,580000],[1441238400000,580000],[1441324800000,578000],[1441411200000,578000],[1441584000000,577000],[1441670400000,579000],[1441711800000,579000],[1441756800000,581000],[1441843200000,576000],[1441929600000,580000],[1442016000000,578000],[1442188800000,577000],[1442275200000,579000],[1442361600000,579000],[1442448000000,585000],[1442534400000,590000],[1442620800000,591000],[1442793600000,593000],[1442880000000,591000],[1442966400000,589000],[1443139200000,606000],[1443225600000,604000],[1443398400000,606000],[1443484800000,601000],[1443571200000,600000],[1443657600000,596000],[1443744000000,594000],[1443830400000,600000],[1444003200000,601000],[1444089600000,597000],[1444205460000,597000],[1444262400000,592000],[1444348800000,587000],[1444435200000,572000],[1444608000000,576000],[1444694400000,577000],[1444897020000,588000],[1444953600000,583000],[1445040000000,581000],[1445212800000,586000],[1445299200000,583000],[1445328000000,583000],[1445385600000,585000],[1445472000000,583000],[1445558400000,580000],[1445644800000,578000],[1445817600000,578000],[1445904000000,579000],[1445990400000,579000],[1446076800000,578000],[1446193020000,572000],[1446249600000,573000],[1446453360000,572000],[1446508800000,571000],[1446595200000,570000],[1446681600000,570000],[1446768000000,570000],[1446854400000,570000],[1447057620000,570000],[1447113600000,570000],[1447200000000,570000],[1447286400000,570000],[1447372800000,569000],[1447459200000,569000],[1447632000000,569000],[1447718400000,569000],[1447804800000,569000],[1447891200000,569000],[1447977600000,569000],[1448064000000,568000],[1448150400000,569000],[1448236800000,569000],[1448323200000,568000],[1448439034000,568000],[1448525117000,567000],[1448610758000,568000],[1448698398000,567000],[1448870869000,566000],[1448958903000,567000],[1449043074000,567000],[1449129275000,566000],[1449215715000,567000],[1449299160000,566000],[1449475238000,568000],[1449562718000,567000],[1449733812000,567000],[1449821330000,568000],[1449902564000,568000],[1450080572000,568000],[1450165583000,567000],[1450254158000,567000],[1450339477000,567000],[1450425708000,566000],[1450686884000,567000],[1450771230000,567000],[1450857789000,565000],[1451290723000,565000],[1451376799000,565000],[1451462856000,565000],[1451549339000,565000],[1451894931000,565000],[1451982417000,566000],[1452068006000,566000],[1452152774000,567000],[1452239818000,569000],[1452322624000,568000],[1452499552000,568000],[1452583320000,567000],[1452671758000,565000],[1452758600000,566000],[1452844371000,563000],[1452929793000,562000],[1453104175000,565000],[1453190078000,565000],[1453276711000,565000],[1453363566000,567000],[1453449414000,567000],[1453534270000,565000],[1453709139000,564000],[1453795329000,567000],[1453880949000,572000],[1453968087000,573000],[1454054875000,570000],[1454057764000,570000],[1454140933000,568000],[1454313461000,568000],[1454313701000,568000],[1454399570000,567000],[1454486100000,566000],[1454572799000,570000],[1454660151000,572000],[1454743782000,578000],[1455004884000,584000],[1455092585000,582000],[1455179870000,581000],[1455264278000,593000],[1455348268000,595000],[1455524186000,594000],[1455609936000,586000],[1455697246000,580000],[1455782656000,583000],[1455869661000,593000],[1455955339000,595000],[1456127970000,594000],[1456214648000,583000],[1456301349000,587000],[1456386999000,587000],[1456474895000,591000],[1456556787000,584000],[1456733977000,584000],[1456820844000,593000],[1456905680000,588000],[1456992245000,590000],[1457080272000,594000],[1457163624000,591000],[1457339165000,593000],[1457425482000,590000],[1457509949000,591000],[1457596118000,588000],[1457684161000,595000],[1457764088000,586000],[1457943806000,585000],[1458029651000,580000],[1458030104000,580000],[1458115707000,579000],[1458202720000,593000],[1458288322000,591000],[1458547463000,587000],[1458635541000,585000],[1458719833000,587000],[1458807021000,578000],[1458979125000,579000],[1459151383000,580000],[1459241379000,583000],[1459324731000,592000],[1459411634000,583000],[1459497803000,584000],[1459582726000,580000],[1459757376000,582000],[1459843082000,579000],[1459930511000,586000],[1460016526000,584000],[1460103162000,589000],[1460189249000,586000],[1460360413000,589000],[1460448157000,594000],[1460533536000,592000],[1460621178000,588000],[1460708867000,585000],[1460792138000,585000],[1460966997000,586000],[1461052029000,586000],[1461140328000,592000],[1461226226000,587000],[1461312593000,590000],[1461397360000,587000],[1461572135000,585000],[1461657469000,586000],[1461745348000,589000],[1461830218000,591000],[1461916570000,598000],[1462003731000,608000],[1462176365000,608000],[1462263297000,606000],[1462348690000,605000],[1462606663000,603000],[1462780976000,607000],[1462868587000,603000],[1462953521000,602000],[1463039763000,606000],[1463126745000,602000],[1463214499000,605000],[1463386514000,606000],[1463473132000,606000],[1463559018000,607000],[1463645664000,604000],[1463733292000,608000],[1463817568000,608000],[1463991747000,606000],[1464077118000,606000],[1464163069000,601000],[1464249251000,600000],[1464337283000,599000],[1464422064000,599000],[1464596120000,595000],[1464681721000,597000],[1464768891000,598000],[1464854235000,598000],[1464943325000,597000],[1465027193000,605000],[1465200571000,606000],[1465285760000,603000],[1465372271000,598000],[1465459700000,602000],[1465545281000,602000],[1465640017000,608000],[1465805165000,609000],[1465892299000,612000],[1465977658000,614000],[1466064007000,616000],[1466086222000,623000],[1466150766000,610000],[1466234580000,621000],[1466409841000,614000],[1466496116000,610000],[1466581541000,603000],[1466668235000,602000],[1466755197000,601000],[1466765151000,617000],[1466836478000,628000],[1467015206000,630000],[1467099994000,628000],[1467188399000,620000],[1467273181000,616000],[1467361015000,619000],[1468225034000,638000],[1468309504000,632000],[1468397595000,622000],[1468484040000,627000],[1468570221000,621000],[1468654501000,624000],[1468829572000,622000],[1468840363000,622000],[1468914618000,621000],[1469001437000,622000],[1469087972000,617000],[1469175987000,625000],[1469254143000,620000],[1469433680000,620000],[1469519079000,620000],[1469606670000,621000],[1469692558000,625000],[1469709716000,625000],[1469780325000,625000],[1469866546000,628000],[1470038021000,629000],[1470124507000,631000],[1470213082000,635000],[1470298376000,634000],[1470385166000,636000],[1470471010000,626000],[1470644000000,626000],[1470729553000,627000],[1470816073000,629000],[1470902686000,631000],[1470989541000,628000],[1471068705000,626000],[1471248749000,627000],[1471334297000,629000],[1471509388000,632000],[1471594786000,632000],[1471681405000,629000],[1471681848000,629000],[1471852902000,629000],[1471940490000,628000],[1472025863000,629000],[1472110740000,627000],[1472200527000,626000],[1472284825000,625000],[1472457005000,626000],[1472457250000,626000],[1472543483000,627000],[1472630418000,622000],[1472716395000,622000],[1472803932000,623000],[1472891330000,627000],[1473063669000,627000],[1473149662000,626000],[1473235346000,630000],[1473321267000,629000],[1473409368000,627000],[1473410223000,627000],[1473492829000,624000],[1473752544000,624000],[1473837912000,623000],[1473926571000,625000],[1474014823000,624000],[1474098082000,621000],[1474272587000,621000],[1474359512000,622000],[1474444976000,623000],[1474532929000,628000],[1474621283000,627000],[1474704250000,628000],[1474877015000,627000],[1474962681000,626000],[1475048648000,622000],[1475136239000,621000],[1475226269000,621000],[1475311268000,620000],[1475481101000,621000],[1475568477000,620000],[1475655451000,619000],[1475740592000,619000],[1475828330000,619000],[1475918661000,619000],[1475918952000,619000],[1476086052000,619000],[1476172916000,619000],[1476258861000,619000],[1476345396000,620000],[1476433537000,621000],[1476518427000,619000],[1476692854000,620000],[1476778019000,621000],[1476863948000,622000],[1476949936000,622000],[1477037799000,620000],[1477122274000,619000],[1477295375000,621000],[1477382976000,621000],[1477469169000,622000],[1477554908000,619000],[1477643749000,620000],[1477727699000,621000],[1477900700000,621000],[1477986641000,622000],[1478073022000,625000],[1478160489000,626000],[1478248833000,627000],[1478332302000,626000],[1478506022000,625000],[1478590849000,623000],[1478678831000,620000],[1478685947000,630000],[1478766797000,625000],[1478849529000,617000],[1478938081000,613000],[1479110441000,615000],[1479197469000,613000],[1479284330000,614000],[1479369722000,614000],[1479456919000,611000],[1479543464000,610000],[1479715664000,610000],[1479802839000,612000],[1479888033000,611000],[1479975801000,609000],[1480062126000,610000],[1480145060000,609000],[1480321475000,610000],[1480406814000,611000],[1480494168000,612000],[1480579234000,608000],[1480666439000,609000],[1480752933000,608000],[1480926610000,609000],[1481011780000,607000],[1481098704000,606000],[1481183708000,606000],[1481271766000,605000],[1481357108000,605000],[1481616718000,604000],[1481702842000,604000],[1481788685000,603000],[1481876134000,602000],[1481962135000,605000],[1482135019000,606000],[1482221628000,605000],[1482308641000,603000],[1482393982000,604000],[1482484402000,603000],[1482567335000,604000],[1482826237000,605000],[1482911333000,606000],[1482998546000,607000],[1483085851000,608000],[1483431273000,606000],[1483517827000,606000],[1483604476000,607000],[1483691608000,606000],[1483776431000,600000],[1483950376000,602000],[1484036187000,605000],[1484123535000,605000],[1484208530000,607000],[1484296736000,607000],[1484381489000,608000],[1484556378000,609000],[1484638966000,610000],[1484726642000,613000],[1484813830000,610000],[1484900893000,611000],[1484993552000,611000],[1485158770000,613000],[1485244872000,613000],[1485332043000,610000],[1485418646000,607000],[1485504283000,602000],[1485765080000,603000],[1485851112000,603000],[1485936113000,607000],[1486023179000,607000],[1486109292000,609000],[1486197980000,611000],[1486368907000,610000],[1486457449000,612000],[1486541784000,612000],[1486627768000,614000],[1486713955000,608000],[1486799308000,610000],[1486974755000,609000],[1487060738000,608000],[1487233257000,610000],[1487320181000,612000],[1487406177000,610000],[1487579487000,611000],[1487664248000,610000],[1487750084000,611000],[1487837065000,611000],[1487924109000,616000],[1488010100000,618000],[1488181560000,617000],[1488269942000,616000],[1488355874000,613000],[1488442110000,612000],[1488527525000,609000],[1488615493000,608000],[1488788191000,609000],[1488873215000,606000],[1488959063000,603000],[1489046712000,601000],[1489132330000,599000],[1489218205000,600000],[1489392161000,600000],[1489478180000,598000],[1489564639000,597000],[1489652238000,601000],[1489736695000,602000],[1489820756000,603000],[1489998143000,604000],[1489998323000,604000],[1490083933000,605000],[1490170644000,607000],[1490255688000,609000],[1490342427000,609000],[1490425040000,608000],[1490601901000,612000],[1490774437000,610000],[1490860589000,611000],[1490946847000,608000],[1491034653000,609000],[1491206098000,609000],[1491293533000,611000],[1491379721000,611000],[1491465880000,612000],[1491551849000,609000],[1491632993000,610000],[1491812161000,610000],[1491897365000,611000],[1491984871000,614000],[1492071148000,618000],[1492241920000,618000],[1492416436000,620000],[1492504052000,615000],[1492585971000,619000],[1492674624000,615000],[1492762711000,617000],[1492853812000,618000],[1493108022000,615000],[1493108395000,615000],[1493193004000,609000],[1493279973000,610000],[1493365824000,609000],[1493454116000,609000],[1493713034000,607000],[1493798839000,607000],[1493884984000,600000],[1493972257000,598000],[1494055280000,599000],[1494229898000,601000],[1494316995000,600000],[1494402192000,599000],[1494489878000,596000],[1494575815000,601000],[1494657066000,601000],[1494835966000,599000],[1494921153000,600000],[1495008131000,604000],[1495094895000,609000],[1495181168000,605000],[1495274030000,612000],[1495440920000,608000],[1495526668000,609000],[1495612820000,606000],[1495704731000,606000],[1495785798000,607000],[1495862062000,612000],[1496045274000,610000],[1496131036000,610000],[1496218282000,609000],[1496390962000,610000],[1496471197000,616000],[1496651464000,615000],[1496736764000,615000],[1496822787000,619000],[1496909629000,616000],[1496995573000,614000],[1497072984000,610000],[1497254756000,612000],[1497341246000,610000],[1497427106000,612000],[1497515031000,610000],[1497600577000,608000],[1497677372000,607000],[1497859886000,609000],[1497946768000,605000],[1498031895000,606000],[1498119493000,607000],[1499069332000,605000],[1499155184000,601000],[1499241270000,604000],[1499327333000,603000],[1499416422000,602000],[1499497866000,600000],[1499674146000,599000],[1499760181000,600000],[1499849213000,602000],[1499933018000,602000],[1500019925000,602000],[1500103085000,606000],[1500279268000,607000],[1500363861000,607000],[1500451297000,610000],[1500538140000,610000],[1500622898000,610000],[1500711350000,614000],[1500884032000,614000],[1500969050000,613000],[1501055921000,610000],[1501143337000,615000],[1501229852000,615000],[1501314738000,619000],[1501488618000,618000],[1501575017000,617000],[1501662469000,617000],[1501747870000,615000],[1501833904000,617000],[1501921233000,613000],[1502093465000,613000],[1502178618000,613000],[1502265864000,615000],[1502351696000,618000],[1502439189000,621000],[1502440660000,621000],[1502521748000,623000],[1502698659000,621000],[1502783922000,619000],[1502870300000,618000],[1503044449000,624000],[1503125802000,622000],[1503302880000,622000],[1503388859000,624000],[1503475427000,621000],[1503560821000,624000],[1503646942000,623000],[1503729759000,624000],[1503906480000,625000],[1503994055000,634000],[1504079580000,631000],[1504166495000,631000],[1504513282000,638000],[1504599127000,637000],[1504685257000,639000],[1504771226000,636000],[1504857505000,642000],[1504940027000,641000],[1505117304000,637000],[1505202778000,631000],[1505288879000,632000],[1505375587000,629000],[1505462169000,634000],[1505543631000,632000],[1505721357000,629000],[1505807574000,627000],[1505895098000,629000],[1505983377000,627000],[1506068193000,624000],[1506148505000,627000],[1506327214000,626000],[1506411893000,630000],[1506501052000,627000],[1506586302000,625000],[1506673974000,628000],[1506752344000,627000],[1506937290000,621000],[1507018981000,619000],[1507036395000,620000],[1507106072000,622000],[1507192725000,622000],[1507279113000,622000],[1507359251000,628000],[1507538395000,628000],[1507624026000,633000],[1507707587000,636000],[1507796976000,638000],[1507882350000,640000],[1507963567000,645000],[1508141956000,644000],[1508228445000,640000],[1508315398000,638000],[1508400369000,637000],[1508485663000,642000],[1508565110000,639000],[1508744600000,638000],[1508832662000,643000],[1508919583000,639000],[1509005714000,642000],[1509091634000,636000],[1509173160000,641000],[1509351969000,641000],[1509437274000,640000],[1509523633000,637000],[1509610571000,640000],[1509697602000,640000],[1509778553000,634000],[1509957349000,638000],[1510043154000,639000],[1510128663000,637000],[1510215876000,639000],[1510301981000,640000],[1510378554000,636000],[1510560714000,636000],[1510646289000,637000],[1510732919000,638000],[1510819277000,638000],[1510907006000,638000],[1510989184000,643000],[1511165688000,643000],[1511251581000,637000],[1511337967000,639000],[1511424647000,641000],[1511511354000,640000],[1511589877000,639000],[1511769330000,639000],[1511855671000,641000],[1511943167000,640000],[1512029045000,637000],[1512196603000,635000],[1512375093000,633000],[1512461522000,635000],[1512549216000,631000],[1512633973000,631000],[1512721506000,628000],[1512799370000,628000],[1512980815000,628000],[1513065231000,627000],[1513152249000,628000],[1513239011000,633000],[1513325273000,632000],[1513400988000,633000],[1513584375000,632000],[1513671145000,635000],[1513756272000,635000],[1513842069000,637000],[1513930916000,636000],[1514008889000,638000],[1514360974000,642000],[1514447881000,643000],[1514534548000,645000],[1514617502000,647000],[1514881074000,649000],[1514967459000,652000],[1515053690000,647000],[1515139865000,650000],[1515216709000,646000],[1515398523000,648000],[1515485576000,647000],[1515572864000,645000],[1515658614000,648000],[1515744723000,650000],[1515823171000,651000],[1516005958000,650000],[1516088313000,649000],[1516175247000,647000],[1516263325000,643000],[1516349912000,643000],[1516430969000,643000],[1516608341000,643000],[1516694728000,642000],[1516782114000,645000],[1516867789000,651000],[1516954434000,648000],[1517038169000,650000],[1517214299000,651000],[1517299914000,648000],[1517386724000,650000],[1517473900000,653000],[1517560069000,653000],[1517637838000,648000],[1517819802000,648000],[1517904128000,653000],[1517992079000,651000],[1518077456000,649000],[1518162879000,652000],[1518240158000,652000],[1518423293000,651000],[1518509328000,653000],[1518596239000,658000],[1518684063000,663000],[1518851634000,658000],[1519028458000,658000],[1519114682000,656000],[1519202108000,652000],[1519286983000,652000],[1519374369000,656000],[1519455688000,656000],[1519632776000,655000],[1519719205000,657000],[1519804899000,653000],[1519893476000,655000],[1519977848000,658000],[1520059353000,659000],[1520237234000,658000],[1520322818000,657000],[1520410229000,665000],[1520496305000,659000],[1520585722000,658000],[1520666979000,661000],[1520841752000,661000],[1520928780000,660000],[1521014947000,659000],[1521100378000,659000],[1521187166000,656000],[1521273541000,656000],[1521447864000,656000],[1521533124000,658000],[1521620034000,657000],[1521705966000,665000],[1521793832000,664000],[1521875117000,672000],[1522052706000,672000],[1522137197000,673000],[1522224228000,666000],[1522311237000,662000],[1522474052000,662000],[1522656646000,663000],[1522743225000,669000],[1522829637000,666000],[1522916417000,666000],[1523002130000,666000],[1523084746000,667000],[1523261781000,665000],[1523347534000,669000],[1523434330000,670000],[1523521294000,674000],[1523606528000,669000],[1523866115000,671000],[1523953786000,673000],[1524039801000,673000],[1524126744000,674000],[1524213408000,671000],[1524297871000,668000],[1524471139000,668000],[1524556378000,668000],[1524643340000,671000],[1524729584000,668000],[1524815639000,668000],[1524902344000,667000],[1525076587000,668000],[1525248401000,664000],[1525336641000,666000],[1525420953000,670000],[1525501419000,670000],[1525681030000,670000],[1525766281000,671000],[1525853480000,673000],[1526025747000,675000],[1526107874000,673000],[1526285161000,670000],[1526370996000,669000],[1526456298000,665000],[1526544159000,667000],[1526630939000,666000],[1526712304000,667000],[1526889453000,667000],[1526976768000,670000],[1527063422000,670000],[1527150605000,672000],[1527235938000,675000],[1527323169000,672000],[1527497024000,671000],[1527668384000,669000],[1527755542000,668000],[1527926007000,664000],[1528099850000,663000],[1528187201000,662000],[1528273245000,665000],[1528359413000,665000],[1528445610000,665000],[1528530483000,667000],[1529569715000,655000],[1529654923000,660000],[1529739862000,661000],[1529915234000,662000],[1530002063000,660000],[1530173837000,657000],[1530261486000,659000],[1530338376000,663000],[1530520784000,664000],[1530607570000,659000],[1530693042000,665000],[1530778430000,664000],[1530864656000,666000],[1530942637000,665000],[1531123815000,666000],[1531210779000,664000],[1531297828000,663000],[1531383554000,661000],[1531468631000,663000],[1531552739000,660000],[1531728314000,660000],[1531816077000,660000],[1531902635000,656000],[1531987610000,656000],[1532073953000,655000],[1532158713000,660000],[1532333529000,660000],[1532420946000,656000],[1532506219000,656000],[1532593504000,662000],[1532680589000,659000],[1532756118000,660000],[1532938729000,659000],[1533024705000,654000],[1533112759000,656000],[1533198441000,654000],[1533286659000,651000],[1533543905000,654000],[1533630038000,652000],[1533642300000,660000],[1533716802000,653000],[1533803523000,651000],[1533887816000,650000],[1533970841000,650000],[1534148556000,650000],[1534234113000,649000],[1534320236000,649000],[1534408254000,645000],[1534751602000,648000],[1534839354000,649000],[1535011237000,650000],[1535098580000,648000],[1535181816000,657000],[1535357200000,654000],[1535444785000,655000],[1535531950000,652000],[1535617767000,655000],[1535703405000,652000],[1535785913000,654000],[1535963657000,654000],[1536049069000,656000],[1536136161000,655000],[1536222849000,661000],[1536309549000,662000],[1536393405000,659000],[1536567932000,659000],[1536652651000,659000],[1536743005000,662000],[1536828162000,667000],[1536913970000,663000],[1536998019000,661000],[1537172370000,661000],[1537259668000,664000],[1537345483000,666000],[1537432560000,668000],[1537519302000,668000],[1537604608000,665000],[1537776847000,663000],[1537863224000,666000],[1537950867000,667000],[1538036354000,666000],[1538124308000,660000],[1538202493000,663000],[1538382694000,663000],[1538383228000,663000],[1538469309000,662000],[1538474477000,662000],[1538555429000,670000],[1538640325000,670000],[1538727351000,671000],[1538807651000,676000],[1538984989000,675000],[1539071276000,668000],[1539158303000,669000],[1539245870000,669000],[1539246361000,669000],[1539333499000,680000],[1539410125000,676000],[1539591274000,677000],[1539677441000,681000],[1539763882000,679000],[1539778120000,679000],[1539850005000,676000],[1539937719000,678000],[1539941387000,678000],[1540021445000,680000],[1540196499000,680000],[1540283240000,677000],[1540368979000,682000],[1540370377000,682000],[1540454237000,682000],[1540540497000,681000],[1540624856000,682000],[1540802030000,682000],[1540887013000,681000],[1540974044000,678000],[1541059953000,675000],[1541147705000,681000],[1541231536000,678000],[1541405885000,678000],[1541492528000,673000],[1541578939000,670000],[1541664836000,665000],[1541752044000,662000],[1541836127000,660000],[1542011938000,659000],[1542096916000,660000],[1542182544000,663000],[1542192149000,663000],[1542268265000,663000],[1542269255000,662000],[1542356458000,664000],[1542438954000,662000],[1542615042000,662000],[1542616048000,662000],[1542619592000,662000],[1542787621000,662000],[1542802230000,662000],[1542873431000,665000],[1542959658000,665000],[1543042832000,662000],[1543222100000,662000],[1543308252000,661000],[1543394917000,657500],[1543481303000,661000],[1543565792000,659000],[1543649581000,657000],[1543823233000,655000],[1543912838000,656500],[1543998787000,660000],[1544085707000,662000],[1544169344000,665000],[1544258535000,668500],[1544428780000,669000],[1544517697000,666000],[1544603001000,668000],[1544690377000,668000],[1544774902000,665000],[1544856668000,664000],[1545034840000,664000],[1545121529000,668000],[1545206886000,667000],[1545293828000,662000],[1545380609000,669000],[1545463228000,666000],[1545812961000,671000],[1545897265000,674000],[1545982696000,674000],[1546071162000,676000],[1546245280000,676000],[1546416020000,674000],[1546502725000,676000],[1546590102000,681000],[1546675775000,673000],[1546848101000,673000],[1546936100000,669000],[1547022328000,666000],[1547107680000,671000],[1547193164000,669000],[1547275458000,669000],[1547453631000,669000],[1547540744000,669000],[1547627793000,670000],[1547713243000,672000],[1547799329000,672000],[1548057963000,670000],[1548145205000,669000],[1548231709000,671000],[1548317148000,669000],[1548404708000,667000],[1548486842000,677000],[1548664309000,675000],[1548750261000,672000],[1548836421000,676000],[1548922767000,680000],[1549007948000,679000],[1549097595000,675000],[1549268788000,675000],[1549441821000,675000],[1549527480000,672000],[1549613490000,674000],[1549695803000,675000],[1549872319000,675000],[1549958488000,673000],[1550045268000,676000],[1550131983000,673000],[1550218641000,677000],[1550301131000,681000],[1550477208000,680000],[1550564032000,683000],[1550650941000,689000],[1550736663000,686000],[1550823007000,682000],[1550905177000,684000],[1551082323000,683000],[1551168352000,680000],[1551256582000,679000],[1551340301000,674000],[1551428505000,673000],[1551512422000,669000],[1551688968000,665500],[1551774886000,665000],[1551861331000,665500],[1551945889000,665500],[1552033297000,664500],[1552118611000,669000],[1552293404000,672500],[1552379186000,674000],[1552465556000,679000],[1552552278000,680000],[1552638257000,675000],[1552728230000,680000],[1552899602000,678500],[1552985492000,675500],[1553071621000,676500],[1553156993000,680000],[1553243610000,672000],[1553328559000,676000],[1553502314000,675000],[1553588435000,681000],[1553674991000,676000],[1553761420000,674000],[1553850038000,669000],[1554107587000,669000],[1554194506000,669000],[1554366535000,670000],[1554453324000,669500],[1554538112000,669500],[1554713716000,669500],[1554798239000,671000],[1554885006000,672500],[1554970569000,673500],[1555056363000,669000],[1555146686000,668500],[1555315610000,669000],[1555402670000,666500],[1555576027000,665000],[1555659437000,665000],[1555748430000,665000],[1555835396000,665000],[1555921474000,665000],[1556008801000,665000],[1556094501000,665000],[1556180525000,667000],[1556268256000,670000],[1556354378000,673500],[1556526773000,673000],[1556613770000,670500],[1556699233000,673000],[1556786022000,670000],[1556872362000,669000],[1556956720000,674000],[1557130987000,673000],[1557218157000,674000],[1557304176000,674500],[1557391297000,671000],[1557476964000,673000],[1557565045000,673500],[1557736263000,673500],[1557823220000,678000],[1557908820000,678000],[1557994475000,678000],[1558081261000,674000],[1558167512000,672000],[1558342047000,672000],[1558427537000,672000],[1558513233000,671000],[1558600093000,671000],[1558685958000,675000],[1558946795000,674000],[1559031917000,671000],[1559119217000,670000],[1559290798000,675000],[1560154436000,690000],[1560241912000,682000],[1560328483000,682000],[1560415008000,684000],[1560500805000,690000],[1560587205000,690000],[1560760165000,688000],[1560855423000,691000],[1560934657000,693000],[1561020205000,703000],[1561104561000,711000],[1561115782000,716000],[1561190139000,708000],[1561365110000,711500],[1561450828000,722000],[1561537214000,718000],[1561625954000,716000],[1561711551000,720000],[1561883503000,714000],[1561970706000,708000],[1562055688000,703000],[1562142357000,723000],[1562227555000,720000],[1562311266000,718000],[1562396428000,710000],[1562573920000,709000],[1562660385000,708000],[1562746343000,708000],[1562831968000,720000],[1562920024000,710000],[1563002815000,715000],[1563178227000,715000],[1563264919000,711000],[1563351440000,706000],[1563440195000,714000],[1563524950000,723000],[1563694301000,712000],[1563783820000,713000],[1563870425000,714000],[1563955356000,712000],[1564042593000,717000],[1564131123000,711000],[1564215520000,713000],[1564305469000,713000],[1564388049000,714000],[1564475903000,716000],[1564562240000,720000],[1564647893000,711500],[1564735339000,726000],[1564819352000,731000],[1564994294000,733000],[1565079835000,748000],[1565167383000,755000],[1565252229000,762000],[1565337024000,761000],[1565423456000,756000],[1565596939000,758000],[1565683988000,764000],[1565769818000,763000],[1565856169000,768000],[1565943305000,775000],[1566034161000,768000],[1566112264000,768000],[1566202797000,766000],[1566290139000,758000],[1566375835000,765000],[1566461149000,764000],[1566547589000,760000],[1566632672000,774000],[1566807671000,783000],[1566894773000,775500],[1566979899000,781000],[1567065858000,780000],[1567152974000,775000],[1567237366000,772000],[1567413293000,777000],[1567499288000,774000],[1567587422000,784000],[1567670066000,784000],[1567759820000,774000],[1567845185000,768000],[1567932698000,768000],[1568018156000,767000],[1568104036000,763000],[1568191244000,760000],[1568275373000,761000],[1568363000000,762000],[1568448625000,754000],[1568622276000,762000],[1568708238000,762000],[1568794567000,766000],[1568879888000,761000],[1568967164000,765000],[1569047874000,772000],[1569227663000,771000],[1569313765000,774000],[1569399950000,778000],[1569486475000,771000],[1569571790000,771000],[1569660652000,770000],[1569740980000,770000],[1569834245000,770000],[1569918944000,760000],[1570002067000,764000],[1570089052000,771000],[1570174275000,773000],[1570259252000,770000],[1570345192000,770000],[1570437412000,770000],[1570522166000,765000],[1570608900000,771000],[1570698308000,775000],[1570781322000,767000],[1570868187000,765000],[1570948487000,765000],[1571041033000,763000],[1571126933000,765000],[1571212339000,761000],[1571298739000,767000],[1571387551000,767000],[1571468801000,765000],[1571556055000,765000],[1571644873000,765000],[1571731087000,761000],[1571818186000,760000],[1571904055000,761000],[1571989812000,763000],[1572076212000,766000],[1572171135000,766000],[1572250616000,766000],[1572337464000,761000],[1572423897000,760000],[1572510524000,764000],[1572597008000,773000],[1572678023000,773000],[1572776169000,773000],[1572857392000,772000],[1572942719000,767000],[1573030125000,759000],[1573116626000,759000],[1573201747000,754000],[1573284392000,750000],[1573460919000,751000],[1573547041000,750000],[1573634858000,752000],[1573721441000,755000],[1573807841000,757000],[1573893925000,756000],[1573980399000,756000],[1574065826000,757000],[1574153007000,758000],[1574237593000,760000],[1574323933000,760000],[1574410905000,757000],[1574497163000,756000],[1574583634000,756000],[1574671311000,756000],[1574756661000,752000],[1574843576000,754000],[1574844398000,754000],[1574929675000,753000],[1574929714000,753000],[1575014893000,753000],[1575094261000,756000],[1575274734000,755000],[1575364734000,756000],[1575447663000,762000],[1575534072000,761000],[1575621202000,760000],[1575702124000,756000],[1575788571000,756000],[1575879901000,753000],[1575965767000,752000],[1576053036000,753000],[1576139518000,759000],[1576225218000,755000],[1576312470000,759000],[1576393755000,759000],[1576485782000,758000],[1576570644000,760000],[1576657230000,761000],[1576743608000,760000],[1576830178000,760000],[1576911923000,761000],[1577089167000,761000],[1577348806000,767000],[1577433701000,771000],[1577693894000,771000],[1577780755000,771000],[1577952627000,771000],[1578040473000,775000],[1578123795000,783000],[1578299384000,792000],[1578385487000,793000],[1578473679000,808000],[1578559469000,791000],[1578644875000,786000],[1578732505000,789000],[1578903465000,787000],[1578990284000,776000],[1579077709000,776000],[1579162853000,781000],[1579248571000,777000],[1579340045000,779000],[1579509547000,778000],[1579595195000,780000],[1579681626000,778000],[1579768254000,781000],[1579852533000,777000],[1580113887000,783000],[1580200936000,783000],[1580286188000,780000],[1580372144000,783000],[1580458476000,783000],[1580547458000,790000],[1580683061000,790000],[1580719015000,788000],[1580805303000,787000],[1580891637000,780000],[1580978101000,779000],[1581061837000,781000],[1581323811000,784000],[1581410195000,785000],[1581495105000,783000],[1581581811000,783000],[1581667623000,786000],[1581748734000,789000],[1581846933000,789000],[1581929106000,788000],[1582014909000,788000],[1582100666000,792000],[1582188181000,797000],[1582273846000,802000],[1582353954000,813000],[1582440427000,813000],[1582534395000,818000],[1582564515000,828000],[1582621474000,818000],[1582705381000,817000],[1582792318000,822000],[1582878525000,825000],[1582966232000,815000],[1583103028000,815000],[1583139414000,819000],[1583224428000,824000],[1583311048000,836000],[1583397018000,831000],[1583481298000,846000],[1583564608000,851000],[1583742706000,860000],[1583829159000,851000],[1583915388000,848000],[1584001942000,840000],[1584086926000,821000],[1584165965000,818000],[1584256346000,818000],[1584347653000,828000],[1584433786000,810000],[1584520258000,835000],[1584606584000,823000],[1584691099000,833000],[1584713938000,868000],[1584777167000,879000],[1584863654000,879000],[1584953395000,870000],[1584966959000,900000],[1585040824000,928000],[1585212717000,933000],[1585297734000,933000],[1585556479000,935000],[1585642747000,933000],[1585728619000,920000],[1585816234000,927000],[1585902458000,953000],[1585988810000,943000],[1586162302000,940000],[1586248347000,972000],[1586333459000,955000],[1586420112000,947000],[1586598276000,960000],[1586766112000,961000],[1586851856000,957000],[1586939245000,952000],[1587027923000,948000],[1587111767000,951000],[1587199510000,936000],[1587372259000,926000],[1587460185000,933000],[1587544619000,937000],[1587630444000,943000],[1587717666000,953000],[1587805617000,952000],[1587974594000,948000],[1588062912000,944000],[1588148240000,937000],[1588234685000,937000],[1588409101000,925000],[1588581253000,923000],[1588666534000,922000],[1588753380000,922000],[1588926768000,927000],[1589013435000,920000],[1589187290000,920000],[1589273435000,912000],[1589357625000,917000],[1589444272000,919000],[1589531125000,926000],[1589619438000,928000],[1589791108000,934000],[1589876896000,924000],[1589962998000,926000],[1590135872000,916000],[1590483612000,917000],[1590567582000,909000],[1590654935000,908000],[1590740835000,913000],[1590827638000,914000],[1591087610000,920000],[1591172758000,904000],[1591259216000,887000],[1591346473000,888000],[1591433711000,876000],[1591604091000,876000],[1591690500000,875000],[1591779018000,881000],[1591865224000,893000],[1591950716000,886000],[1592037685000,900000],[1592210200000,902000],[1592296385000,898000],[1592383704000,895000],[1592469023000,900000],[1592555818000,895000],[1592640060000,905000],[1592735690000,905000],[1592814266000,907000],[1592900776000,908000],[1592988046000,916000],[1593075168000,907000],[1593161810000,910000],[1593244577000,912000],[1593326016000,912000],[1593420244000,911000],[1593506166000,918000],[1593592591000,919000],[1593678269000,915000],[1593765800000,928000],[1593854125000,930000],[1593936225000,930000],[1594025001000,931000],[1594110806000,934000],[1594196962000,934000],[1594283182000,940000],[1594370884000,937000],[1594455129000,937000],[1594628314000,938000],[1594714792000,938000],[1594801410000,942000],[1594890443000,949000],[1594975867000,944000],[1595061011000,956000],[1595138325000,956000],[1595233775000,956000],[1595320774000,963000],[1595407893000,982000],[1595492967000,977000],[1595580019000,984000],[1595665701000,989000],[1595755970000,989000],[1595838345000,997000],[1595926067000,1022000],[1595938920000,1013000],[1596011206000,1013000],[1596097602000,1016000],[1596271816000,1028000],[1596443372000,1028000],[1596529792000,1029000],[1596617294000,1048000],[1596702630000,1054000],[1596791984000,1065000],[1596875354000,1055000],[1596954702000,1055000],[1597048190000,1054000],[1597134459000,1056000],[1597224718000,1026000],[1597307567000,1028000],[1597394304000,1040000],[1597480902000,1035000],[1597557257000,1035000],[1597651666000,1030000],[1597741190000,1050000],[1597827033000,1058000],[1597912654000,1030000],[1597997621000,1031000],[1598086093000,1027000],[1598165726000,1027000],[1598257913000,1023000],[1598344533000,1021000],[1598431375000,1011000],[1598516575000,1019000],[1598603038000,1012000],[1598691406000,1027000],[1598784248000,1027000],[1598863524000,1030000],[1598948882000,1020000],[1598962991000,1026000],[1599035945000,1024000],[1599121443000,1024000],[1599209576000,1021000],[1599294365000,1020000],[1599380776000,1020000],[1599467157000,1020000],[1599553716000,1015000],[1599640823000,1017000],[1599724953000,1027000],[1599813603000,1028000],[1599900001000,1031000],[1599984438000,1031000],[1600072196000,1031000],[1600157850000,1037000],[1600246397000,1030000],[1600330667000,1030000],[1600418247000,1030000],[1600504582000,1023000],[1600598566000,1023000],[1600676234000,1024000],[1600762955000,1009000],[1600848781000,1007000],[1600868588000,1007000],[1600937076000,1002000],[1601022688000,1009000],[1601109510000,1006000],[1601190320000,1006000],[1601281232000,1006000],[1601367790000,1014000],[1601454100000,1016000],[1601539499000,1013000],[1601627119000,1015000],[1601713556000,1014000],[1601803749000,1014000],[1601886473000,1015000],[1601972534000,1017000],[1602058722000,999000],[1602145494000,1004000],[1602230835000,1007000],[1602319211000,1019000],[1602400300000,1019000],[1602490874000,1017000],[1602577509000,1015000],[1602663039000,1007000],[1602750323000,1009000],[1602835930000,1011000],[1602921949000,1008000],[1603006651000,1008000],[1603095456000,1008000],[1603181356000,1008000],[1603268876000,1012000],[1603354349000,1011000],[1603440791000,1007000],[1603528031000,1008000],[1603607520000,1008000],[1603700709000,1007000],[1603787119000,1007000],[1603873368000,1007000],[1603959924000,995000],[1604046358000,992000],[1604134139000,996000],[1604217574000,996000],[1604306172000,994000],[1604391496000,1004000],[1604478594000,1004000],[1604564721000,1000000],[1604650618000,1009000],[1604738727000,1004000],[1604816254000,1004000],[1604910316000,1006000],[1604997198000,972000],[1605082675000,970000],[1605168861000,968000],[1605255256000,978000],[1605340773000,985000],[1605418386000,985000],[1605514341000,985000],[1605601453000,980000],[1605687594000,975000],[1605773827000,973000],[1605862029000,973000],[1605948013000,977000],[1606035584000,977000],[1606121643000,977000],[1606206942000,961000],[1606292956000,953000],[1606378283000,953000],[1606465951000,951000],[1606552004000,942000],[1606631681000,942000],[1606725526000,942000],[1606811348000,938000],[1606897405000,952000],[1606986745000,957000],[1607069362000,961000],[1607156134000,960000],[1607236586000,960000],[1607330789000,959000],[1607416359000,966000],[1607588107000,956000],[1607675630000,954000],[1607758972000,954000],[1607841353000,954000],[1607934260000,952000],[1608020225000,951000],[1608107165000,962000],[1608193386000,965000],[1608279855000,972000],[1608366576000,970000],[1608446198000,970000],[1608540701000,976000],[1608626169000,970000],[1608713194000,966000],[1608799869000,971000],[1608884396000,973000],[1608973058000,973000],[1609051331000,973000],[1609145174000,977000],[1609231798000,967000],[1609317271000,965000],[1609576057000,969000],[1609748886000,975000],[1609835352000,975000],[1609922300000,981000],[1610009094000,971000],[1610094742000,969000],[1610180148000,954000],[1610261620000,954000],[1610353821000,952000],[1610439538000,957000],[1610526188000,965000],[1610612498000,955000],[1610700198000,956000],[1610785307000,948000],[1610877489000,948000],[1610958058000,944000],[1611044095000,952000],[1611131120000,954000],[1611217933000,963000],[1611304074000,961000],[1611391762000,957000],[1611563260000,958000],[1611649398000,958000],[1611736914000,956000],[1611821491000,952000],[1611908129000,954000],[1611995599000,954000],[1612167553000,955000],[1612254910000,954000],[1612340883000,947000],[1612426920000,943000],[1612512903000,930000],[1612600022000,940000],[1612773632000,940000],[1612860371000,943000],[1612945947000,945000],[1613031789000,945000],[1613206366000,940000],[1613378575000,940000],[1613464545000,935000],[1613550215000,922000],[1613637820000,925000],[1613723283000,923000],[1613810253000,930000],[1613890766000,930000],[1613983134000,930000],[1614069274000,938000],[1614156439000,938000],[1614241331000,934000],[1614327764000,922000],[1614415176000,917000],[1614496418000,917000],[1614587357000,923000],[1614674049000,923000],[1614759419000,928000],[1614847014000,923000],[1614932882000,918000],[1615020192000,923000],[1615106711000,923000],[1615191862000,924000],[1615278708000,915000],[1615365259000,930000],[1615450881000,930000],[1615537420000,929000],[1615623552000,926000],[1615795569000,924000],[1615883814000,927000],[1615969652000,927000],[1616057992000,935000],[1616141627000,925000],[1616229869000,934000],[1616317129000,934000],[1616402092000,931000],[1616487448000,929000],[1616573566000,921000],[1616661461000,924000],[1616746840000,921000],[1616834822000,922000],[1616917495000,922000],[1617006433000,921000],[1617093909000,911000],[1617178980000,903000],[1617265609000,913000],[1617352189000,922000],[1617438392000,922000],[1617517960000,922000],[1617609664000,921000],[1617697296000,920000],[1617784025000,924000],[1617869993000,922000],[1617956812000,931000],[1618044709000,927000],[1618128323000,927000],[1618215644000,926000],[1618302516000,924000],[1618390969000,930000],[1618474944000,925000],[1618562118000,935000],[1618648837000,937000],[1618734762000,937000],[1618821157000,939000],[1618907448000,933000],[1618994133000,932000],[1619080164000,940000],[1619165888000,935000],[1619253770000,933000],[1619340492000,933000],[1619425591000,933000],[1619511742000,930000],[1619598143000,926000],[1619684487000,931000],[1619770892000,922000],[1619857899000,921000],[1619945245000,921000],[1620029859000,921000],[1620116341000,930000],[1620203886000,922000],[1620290519000,926000],[1620376920000,934000],[1620463091000,937000],[1620635170000,937000],[1620722142000,933000],[1621240832000,937000],[1621326977000,947000],[1621410868000,948000],[1621496679000,947000],[1621583706000,957000],[1621670702000,958000],[1621755405000,958000],[1621843092000,959000],[1621929405000,955000],[1622102419000,962000],[1622189646000,962000],[1622274827000,965000],[1622367641000,965000],[1622449146000,965000],[1622620425000,961000],[1622707348000,964000],[1622793511000,949000],[1622879910000,960000],[1622964875000,960000],[1623053236000,959000],[1623139938000,960000],[1623225752000,957000],[1623311509000,954000],[1623398224000,957000],[1623485636000,948000],[1623574337000,948000],[1623656879000,945000],[1623744111000,943000],[1623829857000,940000],[1623916480000,928000],[1624003512000,920000],[1624089273000,920000],[1624176796000,920000],[1624261895000,923000],[1624347977000,932000],[1624434813000,930000],[1624520945000,932000],[1624607799000,932000],[1624694084000,934000],[1624787666000,934000],[1624866828000,933000],[1624953362000,932000],[1625039515000,927000],[1625126469000,932000],[1625212655000,935000],[1625299688000,942000],[1625388465000,942000],[1625470954000,941000],[1625557881000,939000],[1625643693000,940000],[1625730966000,945000],[1625817513000,947000],[1625903626000,950000],[1626077165000,950000],[1626162865000,946000],[1626249693000,945000],[1626338392000,953000],[1626421873000,956000],[1626509543000,949000],[1626681854000,950000],[1626854312000,947000],[1626940458000,946000],[1627027131000,946000],[1627112506000,943000],[1627285440000,942000],[1627372321000,940000],[1627458539000,940000],[1627545330000,945000],[1627631292000,953000],[1627718359000,948000],[1627890584000,948000],[1627977680000,948000],[1628063389000,943000],[1628150771000,941000],[1628237143000,939000],[1628323611000,931000],[1628496180000,921000],[1628582194000,925000],[1628754723000,932000],[1628840506000,932000],[1628927418000,942000],[1629100600000,942000],[1629273828000,946000],[1629359893000,947000],[1629446121000,946000],[1629532251000,948000],[1629705685000,946000],[1629791804000,953000],[1629877981000,950000],[1629964154000,942000],[1630051650000,942000],[1630138829000,951000],[1630233859000,951000],[1630309974000,951000],[1630396654000,944000],[1630483855000,941000],[1630569334000,939000],[1630655422000,937000],[1630742957000,943000],[1630831578000,943000],[1630915285000,942000],[1631001202000,940000],[1631088501000,928000],[1631174606000,930000],[1631261110000,934000],[1631347724000,929000],[1631433181000,929000],[1631520237000,929000],[1631606460000,932000],[1631695059000,936000],[1631781460000,932000],[1631867246000,918000],[1631952339000,918000],[1632034585000,918000],[1632125194000,917000],[1632211564000,922000],[1632297377000,926000],[1632384537000,924000],[1632470998000,917000],[1632556980000,918000],[1632637933000,918000],[1632730311000,918000],[1632816720000,918000],[1632902085000,913000],[1632989825000,913000],[1633075544000,922000],[1633162708000,923000],[1633245664000,923000],[1633334915000,924000],[1633420718000,922000],[1633507227000,917000],[1633593872000,918000],[1633681271000,914000],[1633766763000,914000],[1633854306000,914000],[1633939547000,914000],[1634025371000,912000],[1634111780000,916000],[1634198767000,928000],[1634285152000,926000],[1634371506000,914000],[1634457234000,914000],[1634544241000,915000],[1634630512000,915000],[1634717797000,916000],[1634803981000,921000],[1634890141000,925000],[1634975591000,928000],[1635063793000,928000],[1635149115000,929000],[1635235786000,934000],[1635321705000,929000],[1635408450000,930000],[1635495050000,931000],[1635580863000,925000],[1635668035000,925000],[1635754113000,924000],[1635840054000,930000],[1635926952000,929000],[1636013383000,927000],[1636100106000,934000],[1636186020000,946000],[1636273800000,946000],[1636359871000,945000],[1636444477000,943000],[1636531806000,943000],[1636617431000,951000],[1636704765000,956000],[1636791429000,955000],[1636877224000,955000],[1636964206000,955000],[1637048821000,952000],[1637136252000,948000],[1637223472000,956000],[1637308925000,953000],[1637395627000,947000],[1637476277000,947000],[1637567878000,947000],[1637654869000,935000],[1637741413000,929000],[1637827446000,929000],[1637914049000,930000],[1638000018000,929000],[1638080755000,929000],[1638173331000,930000],[1638259878000,930000],[1638346010000,925000],[1638432432000,929000],[1638519794000,926000],[1638606502000,932000],[1638687743000,932000],[1638778526000,932000],[1638865044000,933000],[1638951162000,933000],[1639037362000,930000],[1639123672000,927000],[1639210219000,930000],[1639289303000,930000],[1639382859000,930000],[1639470206000,929000],[1639555476000,924000],[1639641569000,927000],[1639728756000,934000],[1639814575000,934000],[1639894205000,934000],[1639987243000,935000],[1640073939000,934000],[1640160001000,931000],[1640246512000,932000],[1640333808000,933000],[1640592615000,931000],[1640678267000,934000],[1640765261000,932000],[1640851711000,933000],[1640938971000,938000],[1641198426000,945000],[1641283929000,935000],[1641370348000,940000],[1641456064000,941000],[1641542667000,934000],[1641629494000,934000],[1641710411000,934000],[1641801049000,933000],[1641888758000,934000],[1641974926000,940000],[1642061261000,941000],[1642147275000,939000],[1642234327000,938000],[1642315260000,938000],[1642407695000,937000],[1642494261000,939000],[1642578703000,936000],[1642667190000,948000],[1642752587000,947000],[1642839079000,945000],[1642920828000,945000],[1643012203000,944000],[1643098446000,947000],[1643184462000,950000],[1643270910000,938000],[1643359798000,930000],[1643443419000,928000],[1643527430000,928000],[1643617778000,927000],[1643702152000,931000],[1643789053000,932000],[1643876364000,933000],[1643961625000,934000],[1644049560000,935000],[1644130015000,935000],[1644222068000,937000],[1644224330000,937000],[1644307828000,943000],[1644394401000,943000],[1644480774000,945000],[1644567075000,941000],[1644654717000,953000],[1644734826000,953000],[1644825325000,953000],[1644912561000,957000],[1644999602000,946000],[1645084933000,953000],[1645172111000,967000],[1645258182000,969000],[1645340006000,969000],[1645430414000,972000],[1645517790000,972000],[1645604688000,969000],[1645690408000,974000],[1645705724000,984000],[1645729307000,994000],[1645777028000,975000],[1645863177000,969000],[1645949220000,969000],[1646035314000,978000],[1646123056000,977000],[1646209428000,987000],[1646295084000,987000],[1646382429000,990000],[1646467749000,1005000],[1646550489000,1005000],[1646639663000,1013000],[1646727836000,1019000],[1646814338000,1036000],[1646900695000,1010000],[1646985444000,1010000],[1647073207000,1009000],[1647154311000,1009000],[1647245846000,1001000],[1647332070000,994000],[1647418299000,984000],[1647504271000,986000],[1647591748000,991000],[1647677360000,984000],[1647761781000,984000],[1647850009000,983000],[1647936438000,989000],[1648023072000,984000],[1648109676000,994000],[1648195910000,1000000],[1648282049000,999000],[1648365488000,999000],[1648455225000,999000],[1648541263000,985000],[1648627793000,983000],[1648713816000,987000],[1648801031000,989000],[1648887347000,985000],[1648970353000,985000],[1649059778000,985000],[1649145925000,988000],[1649233097000,983000],[1649318689000,984000],[1649405292000,988000],[1649491293000,994000],[1649576289000,994000],[1649664087000,993000],[1649751311000,997000],[1649837540000,1002000],[1649923854000,1006000],[1650010645000,1005000],[1650097166000,1005000],[1650180906000,1005000],[1650269533000,1010000],[1650355253000,1007000],[1650442444000,995000],[1650528897000,998000],[1650615114000,997000],[1650702070000,989000],[1650784714000,989000],[1650874039000,988000],[1650961123000,982000],[1651046948000,981000],[1651133298000,975000],[1652084864000,977000],[1652170396000,970000],[1652257204000,966000],[1652344113000,975000],[1652429654000,969000],[1652515852000,967000],[1652598982000,967000],[1652688999000,967000],[1652776028000,974000],[1652862551000,971000],[1652948439000,973000],[1653035098000,985000],[1653121259000,984000],[1653202338000,984000],[1653292060000,984000],[1653379384000,987000],[1653466838000,992000],[1653552690000,988000],[1653638220000,988000],[1653725813000,986000],[1653807766000,986000],[1653898877000,985000],[1653984086000,983000],[1654072346000,979000],[1654157167000,984000],[1654244488000,989000],[1654330843000,979000],[1654413391000,979000],[1654503273000,980000],[1654588693000,976000],[1654676420000,981000],[1654761723000,983000],[1654849311000,984000],[1654935623000,995000],[1655017227000,995000],[1655108430000,996000],[1655194448000,986000],[1655280655000,984000],[1655367588000,994000],[1655454268000,999000],[1655540338000,999000],[1655623541000,999000],[1655713257000,999000],[1655799647000,999000],[1655885687000,993000],[1655971276000,999000],[1656058777000,992000],[1656145122000,992000],[1656228755000,992000],[1656317072000,994000],[1656403881000,988000],[1656490578000,988000],[1656576432000,988000],[1656663982000,984000],[1656750220000,991000],[1656832511000,991000],[1656922816000,989000],[1657009208000,989000],[1657096119000,977000],[1657181291000,969000],[1657268374000,969000],[1657353863000,969000],[1657527621000,969000],[1657613413000,966000],[1657699844000,964000],[1657786066000,967000],[1657872795000,962000],[1657958835000,962000],[1658041732000,962000],[1658131331000,963000],[1658218743000,961000],[1658305124000,963000],[1658391128000,957000],[1658478052000,965000],[1658564143000,970000],[1658647602000,970000],[1658737010000,969000],[1658823449000,966000],[1658909500000,966000],[1658995839000,978000],[1659082793000,982000],[1659169161000,982000],[1659252849000,982000],[1659340379000,980000],[1659428381000,984000],[1659514714000,978000],[1659599983000,983000],[1659686313000,998000],[1659773935000,989000],[1659857036000,989000],[1659944932000,987000],[1660032135000,996000],[1660119036000,995000],[1660205447000,995000],[1660291646000,990000],[1660378685000,990000],[1660460908000,990000],[1660551502000,988000],[1660638058000,980000],[1660724371000,980000],[1660809622000,975000],[1660896789000,974000],[1660983477000,972000],[1661065383000,972000],[1661155813000,971000],[1661242849000,968000],[1661329386000,972000],[1661414681000,972000],[1661501677000,972000],[1661588287000,964000],[1661671745000,964000],[1661760402000,962000],[1661846780000,965000],[1661934028000,957000],[1662019687000,949000],[1662106710000,947000],[1662193752000,952000],[1662273058000,952000],[1662364743000,951000],[1662453200000,955000],[1662538007000,946000],[1662624843000,950000],[1662711506000,947000],[1662796453000,947000],[1662881118000,947000],[1662970144000,947000],[1663057072000,950000],[1663143045000,942000],[1663229984000,942000],[1663316324000,933000],[1663402682000,940000],[1663483707000,940000],[1663574342000,940000],[1663661849000,942000],[1663747628000,937000],[1663834581000,937000],[1663921141000,941000],[1664007526000,932000],[1664089108000,932000],[1664179786000,932000],[1664266285000,930000],[1664352572000,932000],[1664438510000,942000],[1664525021000,945000],[1664612370000,943000],[1664695327000,943000],[1664785138000,945000],[1664871599000,955000],[1664957984000,962000],[1665043761000,957000],[1665130709000,953000],[1665216255000,949000],[1665298617000,949000],[1665389915000,949000],[1665476333000,941000],[1665561520000,941000],[1665647400000,945000],[1665735844000,940000],[1665821430000,935000],[1665905197000,935000],[1665993817000,935000],[1666082013000,940000],[1666167640000,940000],[1666254022000,933000],[1666339861000,936000],[1666426492000,945000],[1666514779000,945000],[1666598700000,946000],[1666686449000,943000],[1666772117000,943000],[1666859283000,948000],[1666945184000,944000],[1667031229000,939000],[1667111940000,939000],[1667204761000,939000],[1667290945000,936000],[1667377586000,944000],[1667463859000,939000],[1667550097000,939000],[1667636508000,954000],[1667718695000,954000],[1667808833000,951000],[1667895657000,950000],[1667981878000,961000],[1668068651000,959000],[1668155128000,974000],[1668241370000,972000],[1668325480000,972000],[1668414022000,970000],[1668499804000,973000],[1668585800000,981000],[1668673300000,981000],[1668759777000,980000],[1668846280000,978000],[1668929739000,978000],[1669018477000,978000],[1669105201000,975000],[1669191233000,977000],[1669278088000,981000],[1669363796000,980000],[1669449840000,981000],[1669533434000,981000],[1669622666000,979000],[1669710029000,977000],[1669795162000,981000],[1669882479000,991000],[1669971041000,1004000],[1670055606000,998000],[1670138075000,998000],[1670227241000,999000],[1670314075000,984000],[1670400503000,984000],[1670486478000,999000],[1670572941000,1003000],[1670660132000,1007000],[1670742851000,1007000],[1670832637000,1005000],[1670919772000,998000],[1671005283000,1013000],[1671092700000,1013000],[1671178758000,1000000],[1671264589000,1008000],[1671347614000,1008000],[1671438002000,1007000],[1671524438000,1004000],[1671610987000,1016000],[1671696557000,1014000],[1671783687000,1004000],[1671870258000,1006000],[1671953553000,1006000],[1672041756000,1006000],[1672128672000,1008000],[1672215788000,1014000],[1672301993000,1012000],[1672389845000,1020000],[1672476477000,1026000],[1672559584000,1026000],[1672646871000,1026000],[1672732463000,1022000],[1672819399000,1024000],[1672906816000,1031000],[1672992121000,1022000],[1673079639000,1032000],[1673155185000,1032000],[1673251729000,1033000],[1673338982000,1035000],[1673425013000,1035000],[1673511792000,1035000],[1673598072000,1042000],[1673683600000,1043000],[1673767687000,1043000],[1673856134000,1042000],[1673943558000,1032000],[1674029370000,1022000],[1674115134000,1029000],[1674202804000,1039000],[1674288071000,1035000],[1674371430000,1035000],[1674461648000,1035000],[1674547227000,1037000],[1674634447000,1040000],[1674720157000,1035000],[1674808044000,1030000],[1674893956000,1029000],[1674976882000,1029000],[1675066102000,1029000],[1675152360000,1027000],[1675239125000,1029000],[1675326195000,1042000],[1675412583000,1029000],[1675499749000,1014000],[1675582167000,1014000],[1675671668000,1014000],[1675756797000,1017000],[1675843962000,1028000],[1675929564000,1033000],[1676016726000,1026000],[1676103851000,1028000],[1676184735000,1028000],[1676275450000,1027000],[1676361925000,1026000],[1676448281000,1029000],[1676534644000,1019000],[1676622221000,1019000],[1676707642000,1022000],[1676787216000,1022000],[1676881565000,1020000],[1676967377000,1023000],[1677053502000,1019000],[1677140635000,1015000],[1677225945000,1016000],[1677313680000,1012000],[1677395100000,1012000],[1677664760000,1021000],[1677751401000,1024000],[1677834573000,1025000],[1678090474000,1033000],[1678176394000,1032000],[1678262862000,1020000],[1678349434000,1024000],[1678436010000,1034000],[1678522660000,1049000],[1678603581000,1049000],[1678695221000,1054000],[1678782205000,1064000],[1678868588000,1054000],[1678954094000,1064000],[1679040680000,1063000],[1679127644000,1088000],[1679212425000,1088000],[1679300609000,1085000],[1679386357000,1084000],[1679482221000,1074000],[1679559678000,1087000],[1679559748000,1087000],[1679645808000,1096000],[1679732593000,1089000],[1679817163000,1089000],[1679904225000,1087000],[1679990880000,1077000],[1680077908000,1082000],[1680164010000,1072000],[1680250033000,1078000],[1680337070000,1072000],[1680423598000,1072000],[1680509450000,1068000],[1680596689000,1073000],[1680682895000,1083000],[1680768244000,1078000],[1680854831000,1074000],[1680941486000,1074000],[1681027441000,1074000],[1681114444000,1072000],[1681200119000,1069000],[1681286412000,1071000],[1681373232000,1075000],[1681460099000,1084000],[1681547465000,1067000],[1681631590000,1067000],[1681719109000,1066000],[1681805140000,1054000],[1682497944000,1062000],[1682583594000,1062000],[1682669559000,1062000],[1682755192000,1056000],[1682837233000,1056000],[1682927953000,1054000],[1683015608000,1053000],[1683101663000,1062000],[1683188265000,1077000],[1683274268000,1074000],[1683360883000,1059000],[1683443997000,1059000],[1683534103000,1059000],[1683620389000,1063000],[1683706668000,1072000],[1683792683000,1072000],[1683879523000,1064000],[1683965317000,1060000],[1684049061000,1060000],[1684137864000,1060000],[1684224843000,1064000],[1684311057000,1057000],[1684398114000,1055000],[1684483135000,1045000],[1684570253000,1056000],[1684654214000,1056000],[1684742745000,1056000],[1684829562000,1056000],[1684829670000,1056000],[1684915932000,1056000],[1685003801000,1048000],[1685088663000,1043000],[1685176189000,1048000],[1685257264000,1048000],[1685347423000,1047000],[1685434002000,1048000],[1685520661000,1056000],[1685608117000,1060000],[1685694538000,1065000],[1685780473000,1057000],[1685858765000,1057000],[1685953740000,1057000],[1686038821000,1065000],[1686125907000,1060000],[1686211308000,1052000],[1686298271000,1062000],[1686385088000,1062000],[1686467417000,1062000],[1686557680000,1062000],[1686644053000,1059000],[1686730345000,1053000],[1686817221000,1052000],[1686903363000,1061000],[1686990181000,1063000],[1687072203000,1063000],[1687162473000,1063000],[1687248604000,1061000],[1687334729000,1057000],[1687421045000,1058000],[1687508804000,1048000],[1687594616000,1047000],[1687670904000,1047000],[1687768232000,1050000],[1687853113000,1053000],[1687940257000,1052000],[1688030769000,1049000],[1688113231000,1049000],[1688113865000,1049000],[1688281889000,1049000],[1688371800000,1054000],[1688371905000,1054000],[1688458775000,1054000],[1688545550000,1058000],[1688631252000,1053000],[1688719111000,1050000],[1688804296000,1059000],[1688887771000,1059000],[1688976173000,1059000],[1689062623000,1064000],[1689149916000,1071000],[1689237847000,1082000],[1689322283000,1080000],[1689322340000,1080000],[1689409210000,1074000],[1689495122000,1074000],[1689583842000,1073000],[1689668318000,1072000],[1689754750000,1080000],[1689840669000,1080000],[1689927619000,1077000],[1690013357000,1072000],[1690099439000,1072000],[1690185857000,1072000],[1690272929000,1071000],[1690359781000,1075000],[1690446438000,1076000],[1690532317000,1068000],[1690619539000,1071000],[1690693737000,1071000],[1690790853000,1071000],[1690878060000,1078000],[1690963526000,1071000],[1691049946000,1067000],[1691137170000,1069000],[1691222734000,1074000],[1691304868000,1074000],[1691395052000,1074000],[1691481653000,1070000],[1691567598000,1066000],[1691655200000,1064000],[1691739807000,1062000],[1691827690000,1062000],[1691911453000,1062000],[1692000874000,1061000],[1692087611000,1060000],[1692173202000,1063000],[1692261976000,1060000],[1692346025000,1060000],[1692433292000,1057000],[1692515347000,1057000],[1692605698000,1057000],[1692692072000,1058000],[1692778682000,1062000],[1692864599000,1069000],[1692950925000,1069000],[1693037865000,1065000],[1693118404000,1065000],[1693210060000,1065000],[1693296356000,1070000],[1693383329000,1077000],[1693468711000,1079000],[1693555686000,1076000],[1693642176000,1076000],[1693726078000,1076000],[1693814712000,1076000],[1693901740000,1075000],[1693988053000,1069000],[1694074887000,1064000],[1694161185000,1068000],[1694247692000,1069000],[1694329946000,1069000],[1694419708000,1070000],[1694506362000,1071000],[1694592596000,1068000],[1694678830000,1066000],[1694763634000,1068000],[1694852227000,1075000],[1694927379000,1075000],[1695024309000,1075000],[1695110237000,1081000],[1695196157000,1080000],[1695284096000,1080000],[1695369540000,1077000],[1695456974000,1079000],[1695538011000,1079000],[1695629326000,1078000],[1695715935000,1072000],[1695802248000,1066000],[1695889488000,1058000],[1695976205000,1053000],[1696062161000,1049000],[1696145265000,1049000],[1696234490000,1049000],[1696320425000,1039000],[1696406433000,1040000],[1696492805000,1043000],[1696580004000,1043000],[1696667264000,1047000],[1696741603000,1047000],[1696838648000,1053000],[1696924954000,1062000],[1697012305000,1063000],[1697098488000,1072000],[1697184839000,1072000],[1697271303000,1088000],[1697353586000,1088000],[1697445705000,1087000],[1697530180000,1085000],[1697617240000,1088000],[1697703666000,1100000],[1697789723000,1112000],[1697876604000,1121000],[1697959933000,1121000],[1698048077000,1117000],[1698135075000,1119000],[1698222099000,1123000],[1698307731000,1125000],[1698393909000,1123000],[1698480730000,1136000],[1698561375000,1136000],[1698654026000,1135000],[1698740411000,1131000],[1698825922000,1123000],[1698912408000,1123000],[1698999509000,1126000],[1699085614000,1125000],[1699167153000,1125000],[1699258710000,1123000],[1699344290000,1111000],[1699431878000,1094000],[1699517436000,1087000],[1699603706000,1092000],[1699690774000,1084000],[1699772752000,1084000],[1699862987000,1084000],[1699948284000,1089000],[1700036021000,1097000],[1700122084000,1096000],[1700208688000,1095000],[1700293828000,1100000],[1700371844000,1100000],[1700467818000,1097000],[1700553930000,1095000],[1700640464000,1097000],[1700727515000,1095000],[1700813178000,1105000],[1700900344000,1110000],[1700983386000,1110000],[1701072501000,1110000],[1701159008000,1115000],[1701245447000,1124000],[1701332136000,1120000],[1701418879000,1115000],[1701506286000,1130000],[1701586307000,1130000],[1701677111000,1145000],[1701763554000,1122000],[1701850517000,1110000],[1701936025000,1116000],[1702022467000,1116000],[1702109953000,1107000],[1702187011000,1107000],[1702282631000,1107000],[1702368622000,1093000],[1702454833000,1100000],[1702540678000,1125000],[1702628041000,1126000],[1702715429000,1114000],[1702798109000,1114000],[1702887700000,1114000],[1702973354000,1118000],[1703059904000,1125000],[1703146060000,1121000],[1703233693000,1128000],[1703319510000,1132000],[1703402091000,1132000],[1703492529000,1132000],[1703580676000,1132000],[1703664355000,1137000],[1703752158000,1141000],[1703837090000,1130000],[1704184810000,1129000],[1704269951000,1129000],[1704355638000,1123000],[1704441357000,1125000],[1704526945000,1128000],[1704612826000,1128000],[1704699841000,1128000],[1704787116000,1121000],[1704873457000,1121000],[1704959930000,1119000],[1705049101000,1124000],[1705133938000,1131000],[1705214696000,1131000],[1705307010000,1130000],[1705392838000,1134000],[1705479178000,1121000],[1705565261000,1115000],[1705652608000,1125000],[1705739249000,1128000],[1705820693000,1128000],[1705911743000,1127000],[1705998566000,1125000],[1706084189000,1128000],[1706170290000,1124000],[1706257413000,1130000],[1706343794000,1132000],[1706425862000,1132000],[1706515785000,1133000],[1706602543000,1142000],[1706688193000,1144000],[1706774915000,1143000],[1706860816000,1151000],[1706948972000,1142000],[1707029625000,1142000],[1707119757000,1140000],[1707207597000,1130000],[1707293803000,1136000],[1707381378000,1139000],[1707466841000,1138000],[1707552511000,1135000],[1707633836000,1135000],[1707726579000,1135000],[1707812197000,1129000],[1707900457000,1114000],[1707984315000,1115000],[1708072719000,1118000],[1708159881000,1124000],[1708240814000,1124000],[1708330172000,1125000],[1708416372000,1128000],[1708502850000,1131000],[1708590446000,1133000],[1708676025000,1133000],[1708762727000,1136000],[1708845100000,1136000],[1708934319000,1135000],[1709023004000,1132000],[1709107204000,1134000],[1709194596000,1138000],[1709279566000,1142000],[1709369364000,1164000],[1709444483000,1164000],[1709540081000,1164000],[1709626740000,1179000],[1709712595000,1186000],[1709799786000,1199000],[1709887076000,1204000],[1709971038000,1208000],[1710053005000,1208000],[1710147213000,1208000],[1710233498000,1210000],[1710320737000,1200000],[1710404781000,1203000],[1710491772000,1194000],[1710577959000,1193000],[1710659508000,1193000],[1710749664000,1193000],[1710836426000,1199000],[1710922417000,1199000],[1711011227000,1219000],[1711097507000,1211000],[1711181203000,1203000],[1711263803000,1203000],[1711354249000,1203000],[1711440353000,1213000],[1711526671000,1217000],[1711612827000,1222000],[1711700905000,1249000],[1711785841000,1249000],[1711861060000,1249000],[1711958790000,1254000],[1712045555000,1256000],[1712132949000,1274000],[1712218262000,1283000],[1712305573000,1279000],[1712391835000,1299000],[1712471597000,1299000],[1712565440000,1289000],[1712651840000,1306000],[1712910400000,1324000],[1712996645000,1310000],[1713061825000,1310000],[1713169926000,1315000],[1713255880000,1321000],[1713341512000,1321000],[1713427403000,1335000],[1713515346000,1345000],[1713601200000,1347000],[1713680039000,1347000],[1713773399000,1343000],[1713858962000,1325000],[1713946348000,1320000],[1714032321000,1319000],[1714118244000,1319000],[1714206625000,1326000],[1714291633000,1326000],[1714377383000,1325000],[1714465185000,1325000],[1714551614000,1310000],[1714637377000,1327000],[1714725214000,1318000],[1714810709000,1313000],[1714890137000,1313000],[1714984233000,1310000],[1715070189000,1318000],[1715156449000,1308000],[1715243062000,1306000],[1715329641000,1326000],[1715415752000,1333000],[1715492284000,1333000],[1715587704000,1333000],[1715674488000,1324000],[1715761993000,1332000],[1715847521000,1354000],[1715934272000,1343000],[1716019424000,1350000],[1716104048000,1350000],[1716192569000,1350000],[1716220556000,1363000],[1716279310000,1358000],[1716366097000,1357000],[1716452669000,1345000],[1716538127000,1325000],[1716625500000,1325000],[1716707175000,1325000],[1716796759000,1327000],[1716883238000,1333000],[1716970471000,1338000],[1717057568000,1329000],[1717142231000,1337000],[1717228967000,1336000],[1717307363000,1336000],[1717402336000,1335000],[1717488312000,1349000],[1717575085000,1336000],[1717662206000,1349000],[1717747192000,1366000],[1717835088000,1328000],[1717917118000,1328000],[1718007286000,1329000],[1718092882000,1330000],[1718180079000,1338000],[1718266641000,1341000],[1718353132000,1333000],[1718439114000,1347000],[1718520839000,1347000],[1718617526000,1344000],[1718699078000,1342000],[1718785957000,1349000],[1718870440000,1355000],[1718958197000,1371000],[1719045422000,1357000],[1719124927000,1357000],[1719217857000,1360000],[1719303640000,1368000],[1719389852000,1361000],[1719476318000,1350000],[1719562469000,1360000],[1719651957000,1365000],[1719731172000,1365000],[1719821836000,1363000],[1719909036000,1368000],[1719994117000,1365000],[1720079995000,1378000],[1720167420000,1383000],[1720254304000,1395000],[1720336122000,1395000],[1720427778000,1396000],[1720513449000,1389000],[1720598894000,1380000],[1720685659000,1386000],[1720772099000,1399000],[1720857222000,1400000],[1720919257000,1400000],[1721031295000,1399000],[1721117630000,1403000],[1721204868000,1420000],[1721290559000,1427000],[1721377532000,1419000],[1721463595000,1404000],[1721543157000,1404000],[1721637124000,1404000],[1721722699000,1404000],[1721809036000,1406000],[1721896558000,1400000],[1721981963000,1386000],[1722067838000,1396000],[1722148921000,1396000],[1722241032000,1402000],[1722328180000,1400000],[1722413191000,1412000],[1722499941000,1433000],[1722586705000,1431000],[1722672845000,1428000],[1722753091000,1428000],[1722846383000,1420000],[1722932536000,1413000],[1723019033000,1399000],[1723105257000,1399000],[1723191463000,1409000],[1723278672000,1401000],[1723360897000,1401000],[1723449390000,1401000],[1723537790000,1419000],[1723624490000,1419000],[1723709511000,1414000],[1723796028000,1404000],[1723883024000,1418000],[1723964256000,1418000],[1724054646000,1418000],[1724141606000,1419000],[1724228384000,1415000],[1724313909000,1410000],[1724400140000,1398000],[1724428619000,1411000],[1724487671000,1420000],[1724566537000,1420000],[1724659692000,1420000],[1724746198000,1420000],[1724833701000,1410000],[1724917922000,1412000],[1725006225000,1413000],[1725092498000,1401000],[1725175003000,1401000],[1725265156000,1401000],[1725350668000,1404000],[1725437023000,1406000],[1725523916000,1409000],[1725610097000,1414000],[1725696537000,1405000],[1725778106000,1405000],[1725869161000,1398000],[1725956431000,1399000],[1726042192000,1411000],[1726128568000,1409000],[1726215493000,1429000],[1726301223000,1439000],[1726370857000,1439000],[1726474303000,1443000],[1726561379000,1444000],[1726646935000,1440000],[1726733142000,1430000],[1726819873000,1443000],[1726906213000,1455000],[1726989591000,1455000],[1727077878000,1455000],[1727164270000,1443000],[1727252404000,1463000],[1727338938000,1461000],[1727423900000,1461000],[1727510759000,1461000],[1727594096000,1461000],[1727683490000,1464000],[1727770227000,1452000],[1727856731000,1464000],[1727942664000,1469000],[1728029331000,1471000],[1728115677000,1482000],[1728192876000,1482000],[1728288654000,1478000],[1728375509000,1481000],[1728404538000,1491000],[1728461387000,1483000],[1728548582000,1473000],[1728635136000,1481000],[1728720783000,1495000],[1728802961000,1495000],[1728893557000,1490000],[1728980079000,1488000],[1729066469000,1491000],[1729152659000,1496000],[1729238946000,1503000],[1729325864000,1514000],[1729409470000,1514000],[1729496842000,1514000],[1729583477000,1510000],[1729670499000,1521000],[1729756601000,1515000],[1729781680000,1529000],[1729805293000,1515000],[1729806173000,1529000],[1729844232000,1529000],[1729929606000,1534000],[1729993994000,1534000],[1730102469000,1527000],[1730189361000,1535000],[1730217486000,1548000],[1730235746000,1535000],[1730237648000,1548000],[1730275330000,1560000],[1730362428000,1567000],[1730449015000,1547000],[1730535237000,1539000],[1730618913000,1539000],[1730707482000,1539000],[1730794224000,1539000],[1730880096000,1543000],[1730968335000,1513000],[1731055344000,1527000],[1731138924000,1517000],[1731224835000,1517000],[1731312610000,1517000],[1731399622000,1482000],[1731487202000,1477000],[1731572900000,1466000],[1731661081000,1470000],[1731745356000,1468000],[1731816070000,1468000],[1731919457000,1476000],[1732005209000,1491000],[1732091835000,1498000],[1732178745000,1508000],[1732263879000,1520000],[1732349006000,1541000],[1732432755000,1541000],[1732523731000,1539000],[1732613050000,1499000],[1732694386000,1504000],[1732782643000,1513000],[1732868738000,1508000],[1732954258000,1514000],[1733040425000,1514000],[1733128084000,1509000],[1733215590000,1514000],[1733300252000,1513000],[1733385930000,1522000],[1733472270000,1514000],[1733559305000,1508000],[1733639936000,1508000],[1733734818000,1503000],[1733818625000,1517000],[1733905726000,1534000],[1733990948000,1548000],[1734079708000,1531000],[1734165082000,1517000],[1734241666000,1517000],[1734336954000,1517000],[1734423036000,1520000],[1734509207000,1520000],[1734597187000,1505000],[1734684801000,1515000],[1734768567000,1533000],[1734854055000,1533000],[1734942417000,1533000],[1735029527000,1520000],[1735114799000,1520000],[1735198713000,1520000],[1735287059000,1528000],[1735371446000,1526000],[1735452122000,1526000],[1735546246000,1528000],[1735635139000,1515000],[1735807389000,1524000],[1735892473000,1543000],[1735978838000,1539000],[1736061441000,1539000],[1736151911000,1539000],[1736237126000,1535000],[1736323285000,1541000],[1736410777000,1546000],[1736497087000,1555000],[1736583301000,1568000],[1736664434000,1568000],[1736757307000,1568000],[1736843806000,1560000],[1736928744000,1564000],[1737016586000,1577000],[1737102730000,1594000],[1737187953000,1587000],[1737265082000,1587000],[1737360783000,1585000],[1737447191000,1591000],[1737533936000,1606000],[1737619872000,1607000],[1737706339000,1608000],[1737794124000,1611000],[1737869519000,1611000],[1737965598000,1609000],[1738052361000,1597000],[1738138361000,1607000],[1738223526000,1606000],[1738311161000,1620000],[1738397219000,1624000],[1738480023000,1624000],[1738570547000,1621000],[1738658119000,1650000],[1738743473000,1663000],[1738828915000,1670000],[1738915829000,1660000],[1739000254000,1662000],[1739083695000,1662000],[1739175478000,1667000],[1739262344000,1692000],[1739347552000,1684000],[1739434146000,1692000],[1739520599000,1701000],[1739609151000,1678000],[1739688231000,1678000],[1739781827000,1671000],[1739866812000,1679000],[1739953185000,1691000],[1740040700000,1708000],[1740125557000,1707000],[1740212769000,1704000],[1740298230000,1704000],[1740384183000,1705000],[1740471250000,1707000],[1740556727000,1694000],[1740642668000,1692000],[1740728962000,1678000],[1740816998000,1672000],[1740899244000,1672000],[1740989001000,1679000],[1741075808000,1704000],[1741162188000,1709000]];

        foreach ($data as $key => $value) {
            $timestamp____ = $value[0];
            $timestamp= $value[0];
            $timestampInSeconds = $timestamp / 1000;
            $timestampInSeconds -= 3600;
            $tanggal_compare = date("Y-m-d", $timestampInSeconds);
            $check_tanggal = DB::table('tbl_trx_harga_emas')->where('update_date', $tanggal_compare)->first();
            $tanggal = date("Y-m-d H:i", $timestampInSeconds);
            if(empty($check_tanggal)){
                $harga   = $value[1];
                DB::table('tbl_tren_emas')->insert([
                    "update_date" => $tanggal,
                    "harga" => $harga,
                    "tanggal_timestamp" => $timestamp____
                ]);
            }
        }
    }
}
