<?php

namespace App\Http\Controllers;

use App\Models\MDataCallToAction;
use Illuminate\Http\Request;

class CallToActionController extends Controller
{
    public function index()
    {
        $data['result'] = MDataCallToAction::first();
        return view('internal.call-to-action.index', $data);
    }
    
    public function updateCallToAction(Request $request)
    {
        $title = $request->title;
        $deskripsi = $request->deskripsi;
        
        MDataCallToAction::truncate();
        MDataCallToAction::create([
            "title" => $title,
            "deskripsi" => $deskripsi,
        ]);

        return Response()->json([
            "status" => true,
            "message" => "Berhasil di simpan"
        ]);
    }
}
