<?php

namespace App\Http\Controllers;

use App\Helpers\MyHelper;
use App\Models\MDataAbout;
use App\Models\MDataCallToAction;
use App\Models\MDataDeskripsiTestimoni;
use App\Models\MDataTestimoni;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BerandaController extends Controller
{
    public function index()
    {
        $data['harga_terakhir'] = DB::select("select update_date, harga, tanggal_timestamp from tbl_tren_emas order by update_date desc limit 1");
        $data['about'] = MDataAbout::first();
        $data['call_toaction'] = MDataCallToAction::first();
        $data['deskripsi_testimoni'] = MDataDeskripsiTestimoni::all();
        $data['deskripsi_testimoni'] = (isset($data['deskripsi_testimoni'][0])) ? $data['deskripsi_testimoni'][0]->deskripsi : null;
        $data['result_testimoni'] = MDataTestimoni::all();
        $data['result_harga'] = DB::select("SELECT harga, berat, update_date FROM tbl_trx_harga_emas WHERE update_date = (SELECT MAX(update_date) FROM tbl_trx_harga_emas) ORDER BY update_date DESC, id_trx_harga_emas ASC");
        $data['result_pergram'] = DB::select("SELECT harga, berat, trx, update_date
            FROM tbl_trx_harga_emas where berat = '1 gr' order by update_date desc limit 1");
        return view('beranda.index', $data);
    }
}
