<?php

namespace App\Http\Controllers;

use App\Models\MDataAbout;
use Illuminate\Http\Request;

class AboutController extends Controller
{
    public function index()
    {
        $data['result'] = MDataAbout::first();
        return view('internal.about.index', $data);
    }

    public function updateAbout(Request $request)
    {
        $title = $request->input('title');
        $deskripsi = $request->input('deskripsi');
        $sub_deskripsi = $request->input('sub-deskripsi');

        $data = MDataAbout::first(); // Get the first record or null if none exist
        
        $imageName = null; // Initialize the image variable
        if ($request->hasFile('image')) {
            // Get the uploaded file
            $image = $request->file('image');
            
            // Generate a unique name for the image
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            
            // Move the image to the 'uploads' folder (you may want to store it in 'storage')
            $image->move(public_path('uploads'), $imageName);
        }

        if (empty($data)) {
            // If no record exists, create a new one
            MDataAbout::create([
                "title" => $title,
                "deskripsi" => $deskripsi,
                "deskripsi_content" => $sub_deskripsi,
                "image" => $imageName, // Save the image name
            ]);
        } else {
            // Ensure we only update the image if it was uploaded
            MDataAbout::where('title', $data->title)->update([
                "title" => $title,
                "deskripsi" => $deskripsi,
                "deskripsi_content" => $sub_deskripsi,
                "image" => $imageName ? $imageName : $data->image, // Keep the old image if no new one is uploaded
            ]);
        }

        // Return a success response
        return Response()->json([
            "status" => true,
            "message" => "Data successfully saved"
        ]);


    }
}
